import os
from pathlib import Path

import pytest
from hydra.core.hydra_config import HydraConfig
from omegaconf import DictConfig, open_dict

from src.data.pub_pred_datamodule import DataModule01
from tests.helpers.run_if import RunIf


def test_train_fast_dev_run() -> None:
    """Run for 1 train, val and test step.

    :param cfg_train: A DictConfig containing a valid training configuration.
    """

    class Params:
        dset = 'etth2'
        context_points = 384
        target_points = 96
        batch_size = 64
        num_workers = 8
        with_ray = False
        features = 'M'

    params = Params
    dm = DataModule01(params)
    for i, batch in enumerate(dm.train_dataloader()):
        print(i, len(batch), batch[0].shape, batch[1].shape)
        break