def pattern_recognition_prompt(metric_names, captions):
    captions_text = "\n".join([f"Series {i+1} ({metric_names[i]}): {caption}" for i, caption in enumerate(captions)])
    
    return f"""**Task:**  
You are asked to design reasoning-style pattern recognition questions for multivariate time series (MTS). Each question must be based only on the provided attribute descriptions of multiple time series and focus on cross-series comparisons and relationships.

**Given Multiple Series Attributes (do not reveal them in the question):**
{captions_text}

**Requirements:**  
1. Use attributes across multiple series: *trends, local fluctuations, seasonality, noise patterns.*  
2. The question must describe **cross-series relationships** and ask whether specific patterns exist when comparing multiple time series. Focus on:
   - Correlation patterns (similar/opposite trends, synchronized fluctuations)
   - Relative comparisons (which series has stronger seasonality, larger amplitude)
   - Time-based relationships (lead-lag effects, phase differences)
   - Collective behaviors (all series trending up, divergent patterns)
3. Do not reveal or hint at the ground-truth attributes in the question. The question must only describe the cross-series pattern conditions.
4. The answer must be strictly `yes` or `no`. The number of yes and no answers should be roughly balanced across the generated questions.
5. Output format must be valid JSON list, with different questions and answers, each item with fields `"question"` and `"answer"`.
6. Ensure the questions are diverse and challenging, requiring deep understanding of multi-series relationships. Avoid simple single-series questions.
7. If there are more than 3 metrics, you can randomly choose some of them (e.g., 2 or 3) to be involved in each question.

**Example:**  
- **Series 1 (CPU):** trend = upward, local fluctuations = upward spike, seasonality = none, noise = low  
- **Series 2 (Memory):** trend = stable, local fluctuations = none, seasonality = daily, noise = medium
- **Output:**  
```json
[{{
    "question": "Do the CPU and Memory metrics show synchronized upward trends with similar fluctuation patterns?",
    "answer": "no"
}},
{{
    "question": "Does one series exhibit clear seasonal patterns while the other shows predominantly trending behavior?",
    "answer": "yes"
}}]""", "\nThe answer format should be yes/no.\nNow, based on the question, please strictly follow the output format requirements and provide the answers. Your answer should be included in the \\answer{} tag. For example, if the answer is \"Yes\", you should respond with \\answer{Yes}."


def numerical_judgement_prompt(metric_names, captions):
    captions_text = "\n".join([f"Series {i+1} ({metric_names[i]}): {caption}" for i, caption in enumerate(captions)])
    
    return f"""**Task:**  
You are asked to design reasoning-style numerical judgment questions for multivariate time series (MTS) in realistic business scenarios. Each question must be based on the provided attribute descriptions and focus on cross-series comparisons and relationships.

**Given Multiple Series Metrics:** {', '.join(metric_names)}
**Given Multiple Series Attributes (do not reveal them in the question):**  
{captions_text}

**Requirements:**  
1. Consider only numerical attributes: *local fluctuation amplitude, seasonal amplitude, seasonal period, max and min values*. Completely ignore noise-related attributes, trend amplitude. Focus on cross-series comparisons.
2. Create scenario-based questions with business context involving multiple metrics:  
   - **Threshold-based judgment:** Use realistic business thresholds and SLA requirements. The threshold must **not** be too close to the true value. For example, if local fluctuation amplitude = 31.01, set threshold = 20 (safe margin), not 30.  
   - **Comparison judgment:** Compare different attribute values in business contexts (e.g., performance vs capacity, peak vs baseline). Avoid cases where the two values are nearly equal.
3. The question must not leak ground-truth values. Only describe realistic business conditions requiring multi-metric analysis.
4. The answer must be strictly `yes` or `no`. Questions should involve realistic monitoring scenarios requiring cross-series analysis. The number of yes and no answers should be roughly balanced across the generated questions.
5. Output format must be a valid JSON list with exactly 5 items, each item having `"question"` and `"answer"`.  
6. Ensure questions are diverse and cover different business scenarios: performance correlation, capacity planning across services, anomaly detection patterns, SLA compliance across systems.
7. (VERY IMPORTANT) Make sure that the threshold is NOT close to the true value. There should be a clear gap between the threshold and the actual value to avoid ambiguity. 
8. The question should be clear and easy to understand.
9. If there are more than 3 metrics, you can randomly choose some of them (e.g., 2 or 3) to be involved in each question.

**Example:**  
- **Metrics:** CPU Utilization, Memory Usage
- **CPU:** local fluctuation amplitude = 31.01, max value = 85, min value = 45
- **Memory:** local fluctuation amplitude = 15.5, max value = 70, min value = 30
- **Output:**  
```json
[{{
    "question": "In a distributed system monitoring scenario, if CPU fluctuations exceed 25 units while Memory fluctuations remain below 20 units, this indicates an imbalanced workload requiring intervention. Does the current system exhibit this imbalanced pattern?",
    "answer": "yes"
}},
{{
    "question": "For capacity planning, if both CPU and Memory peak utilization values are below 80, the system has sufficient headroom for additional workloads. Does this multi-component system meet the headroom requirement?",
    "answer": "yes"
}}]""", "\nThe answer format should be yes/no.\nNow, based on the question, please strictly follow the output format requirements and provide the answers. Your answer should be included in the \\answer{} tag. For example, if the answer is \"Yes\", you should respond with \\answer{Yes}."


def calculation_prompt(metric_names, captions):
    captions_text = "\n".join([f"Series {i+1} ({metric_names[i]}): {caption}" for i, caption in enumerate(captions)])
    
    return f"""**Task:**  
You are asked to design reasoning-style calculation questions for multivariate time series (MTS) in realistic business scenarios. Each question must be based on the provided attribute descriptions and require calculations across multiple series.

**Given Multiple Series Metrics:** {', '.join(metric_names)}
**Given Multiple Series Attributes (do not reveal them in the question):**  
{captions_text}

**Requirements:**  
1. Focus on numerical attributes such as *local fluctuation amplitude, local fluctuation positions, count of local fluctuations, seasonal amplitude, seasonal period, max value, min value* and other meaningful values derived from them. Do not consider noise, trend-related amplitude, start and end values. Perform cross-series calculations.
2. Create business-scenario calculation questions requiring reasoning across multiple series:
   - **Aggregation calculations:** Sum, average, or count across series
   - **Comparative calculations:** Differences, ratios between series
   - **Conditional counting:** Count series meeting specific criteria
   - **Cross-series statistics:** Finding extremes, ranges across the group
3. The question must not reveal ground-truth numerical values. Only describe business context and calculation methodology.
4. The answer must be a single number without units or extra text.
5. Output format must be a valid JSON list with exactly 5 items, each item having `"question"` and `"answer"`.  
6. Ensure questions are diverse covering: financial analysis across portfolios, performance monitoring across services, capacity planning across components, compliance checking across systems.
7. (VERY IMPORTANT) If the question is threshold-related, make sure that the threshold is **NOT** close to the true value. There should be a clear gap between the threshold and the actual value to avoid ambiguity. 
8. If there are more than 3 metrics, you can randomly choose some of them (e.g., 2 or 3) to be involved in each question.

**Example:**  
- **Metrics:** CPU Usage, Memory Usage, Disk I/O
- **CPU:** spike count = 3, max = 85, min = 45
- **Memory:** spike count = 1, max = 70, min = 30  
- **Disk:** spike count = 2, max = 60, min = 20
- **Output:**  
```json
[{{
    "question": "In system monitoring, each component that experiences more than 1 performance spike is flagged for review. How many components require review based on the observed spike patterns?",
    "answer": "2"
}},
{{
    "question": "For capacity assessment, what is the total number of performance anomalies (spikes) detected across all monitored system components?",
    "answer": "6"
}},
{{
    "question": "In infrastructure planning, the component with the highest peak utilization determines bottleneck priority. What is the maximum peak value observed across all system components?",
    "answer": "85"
}}]""", "\nThe answer should be only a number.\nNow, based on the question, please strictly follow the output format requirements and provide the answers. Your answer should be included in the \\answer{} tag. For example, if the answer is \"5.23\", you should respond with \\answer{5.23}."


def causal_prompt(metric_names, captions):
    captions_text = "\n".join([f"Series {i+1} ({metric_names[i]}): {caption}" for i, caption in enumerate(captions)])
    
    return f"""**Task:**  
You are asked to design reasoning-style causal multiple-choice questions for multivariate time series (MTS). Each question must be based on the provided attribute descriptions and focus on the real-world events that could best explain the observed patterns across multiple series.

**Given Multiple Series Metrics (use them in question context):**  
{', '.join(metric_names)}

**Given Multiple Series Attributes (DO NOT reveal them in the question):**  
{captions_text}

**Requirements:**  
1. Construct realistic scenarios where the given cross-series attributes could arise, focusing on real-world events that could best describe the patterns.
2. Each question must include exactly 4 options (A, B, C, D) embedded directly in the question text. Only one option must be correct.
3. Wrong options must be plausible but not consistent with the cross-series attribute patterns.
4. The question must be easy to understand, with clear and concise language, without information leakage. The answers should set according to the attributes in the time series.
5. Output format must be a valid JSON list with exactly 5 items. Each item should have `"question"` and `"answer"`.
6. `"answer"` should be the correct option label (e.g., `"A"`).
7. (VERY IMPORTANT) DO NOT reveal any information about time series attributes themselves in the question part.
8. If there are more than 3 metrics, you can randomly choose some of them (e.g., 2 or 3) to be involved in each question.

**Example:**  
Input Attributes (**MUST NOT** REVEAL THEM in the QUESTION): 
- **CPU:** trend = upward, local fluctuation = spikes, seasonality = none
- **Memory:** trend = stable, local fluctuation = none, seasonality = daily
- **Network:** trend = downward, local fluctuation = spikes, seasonality = none
 
```json
[{{
    "question": "Which event is the best cause of the given timeseries of CPU, Memory and Network? A) There are programs running which seasonal consume the CPU. B) All the programs use the memory with a strong daily pattern, with no memory leak or sudden memory usages. C) There are programs with Network usage increasing over time. D) The CPU usage is decreasing over time with a memory leak.",
    "answer": "B"
}}, ...]""", "\nThe answer format should be only a choice.\nNow, based on the question, please strictly follow the output format requirements and provide the answers. Your answer should be included in the \\answer{} tag. For example, if the answer is \"B\", you should respond with \\answer{B}."


task_to_function = {
    "pattern_recognition": pattern_recognition_prompt,
    "numerical_judgement": numerical_judgement_prompt,
    "calculation": calculation_prompt,
    "causal": causal_prompt
}