def pattern_recognition_prompt(metric_name, caption):
    return f"""**Task:**  
You are asked to design reasoning-style pattern recognition questions for univariate time series (UTS). Each question must be based only on the provided attribute description and the corresponding time series.  

**Given Attributes (do not reveal them in the question):**
{caption}

**Requirements:**  
1. Use only the given attributes: *trend, local fluctuations (e.g., upward spike, convex, increase), seasonality, noise.*  
2. The question must describe a **specific combination** of attributes and ask whether it exists in the given time series. 
3. Do not reveal or hint at the ground-truth label in the question. The question must only describe the pattern conditions, not whether they are satisfied.  
4. The answer must be strictly `yes` or `no`.  
5. Output format must be valid JSON list, with different questions and answers, each item with fields `"question"` and `"answer"`.
6. Ensure the questions are diverse and challenging, which requires deep understanding of time series patterns. Avoid simple or trivial questions.  

**Example:**  
- **Attributes:** trend = upward, local fluctuations = upward spike, seasonality = none, noise = low  
- **Output:**  
```json
[{{
    "question": "Does the time series contain an upward spike followed by a continuous upward trend?",
    "answer": "yes"
}},
{{
    "question": "Does the time series exhibit a downward trend with no significant local fluctuations?",
    "answer": "no"
}}]""", "\nThe answer format should be yes/no.\nNow, based on the question, please strictly follow the output format requirements and provide the answers. Your answer should be included in the \\answer{} tag. For example, if the answer is \"Yes\", you should respond with \\answer{Yes}."

def numerical_judgement_prompt(metric_name, caption):
    return f"""**Task:**  
You are asked to design reasoning-style numerical judgment questions for univariate time series (UTS) in realistic business scenarios. Each question must be based only on the provided attribute description and the corresponding time series.  

**Given Metric Name:** {metric_name}
**Given Attributes (do not reveal them in the question):**  
{caption}  

**Requirements:**  
1. Consider only numerical attributes: *local fluctuation amplitude, seasonal amplitude, seasonal period, max and min values*. Completely ignore noise-related attributes, trend amplitude.  
2. Create scenario-based questions with business context related to the metric type:  
   - **Threshold-based judgment:** Use realistic business thresholds and SLA requirements. The threshold must **not** be too close to the true value. For example, if local fluctuation amplitude = 31.01, set threshold = 20 (safe margin), not 30.  
   - **Comparison judgment:** Compare different attribute values in business contexts (e.g., performance vs capacity, peak vs baseline). Avoid cases where the two values are nearly equal.  
3. The question must not leak the ground-truth values. Only describe realistic business conditions and scenarios.  
4. The answer must be strictly `yes` or `no`. Questions should involve realistic monitoring scenarios, SLA compliance, alert conditions, etc.
5. Output format must be a valid JSON list with exactly 5 items, each item having `"question"` and `"answer"`.  
6. Ensure the 5 questions are diverse and challenging, covering different business scenarios like performance monitoring, capacity planning, anomaly detection, SLA compliance, etc.  
7. (VERY IMPORTANT) Make sure that the threshold is NOT close to the true value. There should be a clear gap between the threshold and the actual value to avoid ambiguity. 

**Example:**  
- **Metric:** CPU Utilization, **Attributes:** local fluctuation amplitude = 31.01, seasonal amplitude = 8.0, seasonal period = 20, max value = 40, min value = -10
- **Output:**  
```json
[{{
    "question": "In a production environment, CPU utilization spikes exceeding 20.0 above baseline are considered critical alerts that require immediate attention. Based on the observed fluctuation patterns, would this system trigger any critical alerts?",
    "answer": "yes"
}},
{{
    "question": "For capacity planning purposes, if the maximum observed utilization is less than 50, the system is considered to have sufficient headroom for additional workloads. Does this system meet the headroom requirement?",
    "answer": "yes"
}},...]```""", "\nThe answer format should be yes/no.\nNow, based on the question, please strictly follow the output format requirements and provide the answers. Your answer should be included in the \\answer{} tag. For example, if the answer is \"Yes\", you should respond with \\answer{Yes}."

def calculation_prompt(metric_name, caption):
    return f"""**Task:**  
You are asked to design reasoning-style calculation questions for univariate time series (UTS) in realistic business and operational scenarios. Each question must be based only on the provided attribute description and the corresponding time series.  

**Given Metric Name:** {metric_name}
**Given Attributes (do not reveal them in the question):**  
{caption}  

**Requirements:**  
1. Focus on numerical attributes such as *local fluctuation amplitude, local fluctuation positions, count of local fluctuations, seasonal amplitude, seasonal period, max value, min value* and other meaningful values derived from them. Do not consider noise, trend-related amplitude, start and end values.
2. Create business-scenario calculation questions requiring reasoning or counting, with the final answer being a **single number**. Questions should be easy to understand and clear.
3. The question must not reveal the ground-truth numerical values. Only describe the business context and calculation methodology clearly.  
4. The answer must be a single number without units or extra text.
5. Clearly state if the answer should be the absolute value or the original value (which can be negative).
6. Output format must be a valid JSON list with exactly 5 items, each item having `"question"` and `"answer"`.  
7. Ensure the 5 questions are diverse and cover different business scenarios: financial analysis, performance monitoring, capacity planning, compliance checking, and operational analytics.
8. (VERY IMPORTANT) If the question is threshold-related, make sure that the threshold is **NOT** close to the true value. There should be a clear gap between the threshold and the actual value to avoid ambiguity. 

**Example:**  
- **Metric:** Memory Usage (GB), **Attributes:** trend amplitude = 12, spike 1 amplitude = 30 and pos = 123, spike 2 amplitude = 40 and pos = 54, spike 3 amplitude = 10 and pos = 201, seasonal amplitude = 8, seasonal period = 20 max value = 85, min value = 15  
- **Output:**  
```json
[{{
    "question": "In incident management, each memory spike above normal operations with amplitude more than 15 triggers an alert. How many alert incidents would the monitoring system generate based on the observed spike patterns?",
    "answer": "2"
}},
{{
    "question": "In incident management, spikes are considered as anomalies. What is the position of the anomaly of the largest amplitude?",
    "answer": "54"
}},
{{
    "question": "In incident management, spikes with amplitudes larger than 5 are considered as anomalies. What is the sum of amplitudes of all anomalies?",
    "answer": "80"
}},...]```""", "\nThe answer should be only a number.\nNow, based on the question, please strictly follow the output format requirements and provide the answers. Your answer should be included in the \\answer{} tag. For example, if the answer is \"5.23\", you should respond with \\answer{5.23}."

def causal_prompt(metric_name, caption):
    return f"""**Task:**  
You are asked to design reasoning-style causal multiple-choice questions for univariate time series (UTS). Each question must be based on the provided attribute description and the metric name.  

**Given Metric Name (use it in the question context):**  
{metric_name}  

**Given Attributes (do not reveal them in the question):**  
{caption}

**Requirements:**  
1. Construct a realistic scenario where the given attributes could arise in the {metric_name} time series.  
2. Each question must include exactly 4 options (A, B, C, D) embedded directly in the question text. Only one option must be correct.  
3. Wrong options must be plausible but not consistent with the given attributes.  
4. The question must require reasoning based on the attributes and the metric’s real-world meaning, not just surface matching.  
5. The difficulty should be non-trivial, requiring causal inference and detailed analysis about the timeseries themselves. The questions should be misleading and hard to answer.
6. Output format must be a valid JSON list with exactly 5 items. Each item should have `"question"` and `"answer"`.  
7. `"answer"` should be the correct option label (e.g., `"A"`).  

**Example:**  
- **Attributes:** trend = upward, local fluctuation = upward spikes, seasonality = none, noise = low  
- **Metric Name:** CPU Utilization  
- **Output:**  
```json
[{{
    "question": "Which of the following events most likely caused the observed pattern in CPU Utilization, showing a general upward trend with occasional sharp spikes? A) A gradual rollout of a new background data-processing job, with occasional batch tasks triggering sharp increases. B) A temporary network outage that completely stops CPU usage. C) Stable user traffic with no significant changes in workload. D) A constant low-level background process running without interruptions.",
    "answer": "A"
}},...]""", "\nThe answer format should be only a choice.\nNow, based on the question, please strictly follow the output format requirements and provide the answers. Your answer should be included in the \\answer{} tag. For example, if the answer is \"B\", you should respond with \\answer{B}."

task_to_function = {
    "pattern_recognition": pattern_recognition_prompt,
    "numerical_judgement": numerical_judgement_prompt,
    "calculation": calculation_prompt,
    "causal": causal_prompt
}