# SAGE


1. Environment setup

    * Change the environment variables and system configurations and execute to set the basepaths appropriately
        ```bash
        source scripts/core/config/dotfiles/bashrc.sh
        ```
    * Based on the basepaths, set the required repo environemtn variables
        ```bash
        source export.sh
        source export.alias.sh
        ```
    * Create the conda environment; tested on python version `3.10.12`
    * Setup the project dependency, `requirements/requirements.sage.txt`


2. Dataset Creations

Ensure `dataset-id` are defined in `data/ddd-datasets.yml` dataset configuration file. This stage create new images for each variants from fullimage to bbox, seg and bboxseg; Each split (train/val/test) of the dataset will be processed. The respective shell scripts can be used with defaults as is or customise dataset details, detection configurations, sample size. The sample size of 'N' will pick at least one sample per class, instead of total N samples. It does not use any augmentation and hence keep `FLOW` value configured to simple. The sample size `0` means no limit and process compelete dataset. Output will be generated inside `logs/annotate-<ddmmyy_hhmmss>`

* [100driver-sf3d-nc10](docs/dataset.100driver-sf3d-nc10.md)
* [sf3d-bydriver](docs/dataset.sf3d.md)

3. Training on dataset variants

Training on Background, foreground dataset of `sf3d-by-driver` and `100-driver-sf3d-nc10` (Day/Cam2) with following architectures used:

* ["densenet121"]='(224,224)'
* ["efficientnet_b0"]='(224,224)'
* ["resnet18"]='(224,224)'
* ["resnet50"]='(224,224)'
* ["squeezenet1_0"]='(224,224)'


Default Experimental settings:

* using `imagenet` pretrain, gets downloaded automatically
* num_class=10
* loss="CrossEntropyLoss"
* epochs=100
* batch_size=32


Trainings can be schedule individually for each variant or can batch schedule

* sf3d-day-bydriver

    ```bash
    ## baseline
    bash scripts/train.loop.m174.sf3d-day-bydriver-pretrain.sh
    ## dataset background variants 
    bash scripts/train.loop.m174.sf3d-day-bydriver-seg-pretrain.sh
    bash scripts/train.loop.m174.sf3d-day-bydriver-bbox-pretrain.sh
    bash scripts/train.loop.m174.sf3d-day-bydriver-bboxseg-pretrain.sh

    ## Batch scheduling
    bash scripts/run.train.loop.m174.sf3d-day-bydriver-pretrain.sh
    ```

* 100-driver-day-cam2-sf3d-nc10
    ```bash
    ## baseline
    bash scripts/train.loop.m174.100-driver-day-cam2-sf3d-nc10-pretrain.sh
    ## dataset background variants 
    bash scripts/train.loop.m174.100-driver-day-cam2-sf3d-nc10-seg-pretrain.sh
    bash scripts/train.loop.m174.100-driver-day-cam2-sf3d-nc10-bbox-pretrain.sh
    bash scripts/train.loop.m174.100-driver-day-cam2-sf3d-nc10-bboxseg-pretrain.sh

    ## 100-driver-day-cam2-sf3d-nc10
    bash scripts/run.train.loop.m174.100-driver-day-cam2-sf3d-nc10-pretrain.sh
    ```

## SAGE FLow

Once the datasets are prepared, models are trained on different variants, SAGE can now generate end to end assessment through a `flowplan` which are created as multiple pipelined stages in cascading manner, different tasks can be done in different stages, or same stage can be configured for all the end to end task execution `data/sage-crossdomain-sf3d-100driver-220925_010101.yml`. The stages are logical blocks defined in fully declarative way, for instance

```yml
flowplan:
  - <logical-name>:
    - {fn: <python-module-name>.<function-in-python-module>, params: {<key>: <value>}}
    - {fn: <python-module-name>.<function-in-python-module>}
```

```yml
flowplan:
  - inference:
    - {fn: inference.load_split, params: {split: train}}
    - {fn: inference.predict}
    - {fn: inference.save_predictions}
    - {fn: inference.save_evaluations}
```

Each logical flow can be enabled or disabled completely. Each flow block executes in sequence, and within each flow block each task also executes in sequence
```yml
run:
  inference: false
  cluster: false
  saliency: true
  embed: false
  divergence: false
  report: false
```

`models` define the models to be evaluated on and on what dataset variants, model input dimension, number of classes, and target layer for generating model saliency. For each different dataset new entry has to be added. The `datasets` defines different dataset variants and used for dataset loading. The `saliency_cfg` defines different saliency methods

```bash
cd ${__CODEHUB_ROOT__}/external
git clone https://github.com/jacobgil/pytorch-grad-cam.git
```

This path is already configured in python path environment variable through `export.sh`
```bash
AI_ROOT__PYTORCH_GRAD_CAM="${__CODEHUB_ROOT__}/external/pytorch-grad-cam"
export PYTHONPATH=$PWD:$AI_ROOT__PYTORCH_GRAD_CAM:$PYTHONPATH
```

Any supported methods by `pytorch-grad-cam` can be configured here. At the time of this writing there were 14 of such saliency methods supported.

`saliency_cfg` has crucial configuration for the entire saliency prepartion - normalization, patchify using grids of different sizes, defaults are `4x4` and `8x8` without padding, saving of different types of formats for analysis and downstream processing which can be disabled or enabled, or format type.

Other keys in the `data/sage-crossdomain-sf3d-100driver-220925_010101.yml` are for self documenting, book keeping and for optimization of workflow in the future scope.


4. Inference

* load split, run inference, save prediction, and evaluations

5. Cluster inference

* load predictions, cluster confidence, save clusters, generate visualization and analysis of clustering

6. Saliency generation


7. Saliency Analysis


8. Saliency Embedding


9. Behavioral Divergence



## Utilities

* test torch cuda compatibility
    ```bash
    bash scripts/torch.cuda-check.sh
    ```

* Dataset mosiacs for original datasets

```bash
bash scripts/sf3d_mosiac.sh
bash scripts/100driver_mosiac.sh
```
