"""
python quick_token_check.py /path/to/saliency/<model>/<method>/
"""
__author__ = "XYZ"


import sys

from pathlib import Path

import numpy as np


def _is_almost_zero(arr, eps=1e-6):
  return float(np.abs(arr).max()) <= eps

def main():
  base = Path(sys.argv[1]) if len(sys.argv) > 1 else Path("saliency")
  parts = ["fg", "bg", "whole"]
  grids = {"4x4": 16, "8x8": 64}

  summary = {}
  for part in parts:
    for glabel, expected_count in grids.items():
      pth = base.glob(f"**/tokens/{part}/*/{glabel}/*.tokens.npy")
      files = list(pth)
      good, bad_shape, all_zero, bad_com = 0, 0, 0, 0
      for f in files:
        arr = np.load(str(f)).astype(np.float32)
        if arr.ndim != 2 or arr.shape[1] != 4:
          bad_shape += 1
          continue
        if arr.shape[0] != expected_count:
          bad_shape += 1
          continue
        if _is_almost_zero(arr[:, 0]):   # mean column all zeros
          all_zero += 1
        # COM check: columns 2,3 should be in [0,1) normally
        com = arr[:, 2:4]
        if not ((com >= 0.0).all() and (com < 1.0).all()):
          bad_com += 1
        good += 1
      summary[f"{part}@{glabel}"] = {"files_total": len(files), "ok": good, "bad_shape": bad_shape,
                                    "all_zero_mean": all_zero, "bad_com": bad_com}
  for k, v in summary.items():
    print(f"{k}: {v}")

if __name__ == '__main__':
  main()
