#!/bin/bash

## __author__="XYZ"
## ----------------------------------------------------------
## Runner script for inference + evaluation on trained models with defined dataset splits

set -euo pipefail

__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}")" && pwd )
_timestamp="$(date +'%d%m%y_%H%M%S')"

## -----------------------------------------------------------------
## Params (override on CLI if needed)
## -----------------------------------------------------------------
NET="${1:-efficientnet_b0}"   # model arch
DATASET="${2:-sf3d-day-bydriver-bboxseg}"
SPLIT="${3:-test}"
NUM_CLASS="${4:-10}"
LOSS="${5:-CrossEntropyLoss}"
WEIGHTS_PATH="${6:-${__DATAHUB_ROOT__}/sage-experimental-logs/xai/train-CrossEntropyLoss_10-180925_092013/efficientnet_b0-bs32-nc10-sf3d-day-bydriver-bboxseg-180925_111836/efficientnet_b0-final.pth}"
DATASETCFG="${7:-data/ddd-datasets.yml}"
INPUT_SIZE="${8:-(224,224)}"
BATCH_SIZE="${9:-64}"
NUM_WORKERS="${10:-4}"
NUM_ITERATIONS="${11:-20}"    # reduce for quick perfstats testing
SAMPLE_LIMIT="${12:-0}"     # limit dataset samples for quick runs
TO_PATH="${13:-logs/inference-${_timestamp}}"

## -----------------------------------------------------------------
## Build args array
## -----------------------------------------------------------------
args=( "--net=${NET}" )
args+=( "--dataset=${DATASET}" )
args+=( "--split=${SPLIT}" )
args+=( "--num_class=${NUM_CLASS}" )
args+=( "--loss=${LOSS}" )
args+=( "--weights_path=${WEIGHTS_PATH}" )
args+=( "--datasetcfg=${DATASETCFG}" )
args+=( "--input_size=${INPUT_SIZE}" )
args+=( "--batch_size=${BATCH_SIZE}" )
args+=( "--num_workers=${NUM_WORKERS}" )
args+=( "--num_iterations=${NUM_ITERATIONS}" )
args+=( "--sample_limit=${SAMPLE_LIMIT}" )
args+=( "--to=${TO_PATH}" )

## -----------------------------------------------------------------
## Run module
## -----------------------------------------------------------------
python -m src.inference "${args[@]}"
