#!/bin/bash

## __author__="XYZ"
## ----------------------------------------------------------
## Runner script for preparing 100-driver dataset filtered to sf3d-equivalent taxonomy (nc=10)

set -euo pipefail

__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}")" && pwd )
_timestamp="$(date +'%d%m%y_%H%M%S')"

## -----------------------------------------------------------------
## Params (override on CLI if needed)
## -----------------------------------------------------------------
MODALITY="${1:-day}"      # day or night
CAMERA_ID="${2:-2}"       # 1–4

SF3D_SUMMARY="${3:-data/datasets/sf3d-bydriver/summary.json}"
TO_PATH="${4:-logs/100driver-sf3d-${_timestamp}}"
SEED="${5:-42}"
LABEL_MAP="${6:-data/label_map_100driver_sf3d.json}"

BASE_DIR="${__DATASET_ROOT__}/100-driver/${MODALITY^}/Cam${CAMERA_ID}"
SPLIT_DIR="${__DATASET_ROOT__}/100-driver/data-splits/Traditional-setting/${MODALITY^}/Cam${CAMERA_ID}"

TRAIN_SPLIT="${SPLIT_DIR}/D${CAMERA_ID}_train.txt"
VAL_SPLIT="${SPLIT_DIR}/D${CAMERA_ID}_val.txt"
TEST_SPLIT="${SPLIT_DIR}/D${CAMERA_ID}_test.txt"

## -----------------------------------------------------------------
## Build args array
## -----------------------------------------------------------------
args=( "--from=${BASE_DIR}" )
args+=( "--from-sf3d-summary=${SF3D_SUMMARY}" )
args+=( "--train-split=${TRAIN_SPLIT}" )
args+=( "--val-split=${VAL_SPLIT}" )
args+=( "--test-split=${TEST_SPLIT}" )
args+=( "--label-map=${LABEL_MAP}" )
args+=( "--to=${TO_PATH}" )
args+=( "--seed=${SEED}" )

## -----------------------------------------------------------------
## Run module
## -----------------------------------------------------------------
python -m src.datasets.prepare_100driver_sf3d "${args[@]}"
