#!/bin/bash

## __author__="XYZ"
## ----------------------------------------------------------
## Runner script for SAGE orchestrator with declarative YAML

set -euo pipefail

__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}")" && pwd )
_timestamp="$(date +'%d%m%y_%H%M%S')"

## -----------------------------------------------------------------
## Params (override on CLI if needed)
## -----------------------------------------------------------------
CONFIG="${1:-data/sage-crossdomain-sf3d-100driver-220925_010101.yml}"
# SPLIT="${2:-test}"
SPLIT="${2:-train}"
DATASETCFG="${3:-data/ddd-datasets.yml}"
TO_PATH="${4:-logs/sage-${_timestamp}}"
GPU="${5:-true}"
SAMPLE_LIMIT="${6:-0}"   # 0 means no limit

## -----------------------------------------------------------------
## Build args array
## -----------------------------------------------------------------
args=( "--config=${CONFIG}" )
args+=( "--split=${SPLIT}" )
args+=( "--datasetcfg=${DATASETCFG}" )
args+=( "--to=${TO_PATH}" )
args+=( "--num_iterations=20" )   # default for quick test; adjust as needed

if [ "${GPU}" = true ]; then
  args+=( "--gpu" )
fi

if [ "${SAMPLE_LIMIT}" -gt 0 ]; then
  args+=( "--sample_limit=${SAMPLE_LIMIT}" )
fi

## -----------------------------------------------------------------
## Run orchestrator
## -----------------------------------------------------------------
python -m src.sage "${args[@]}"
