#!/bin/bash

##__author__='XYZ'
###----------------------------------------------------------

set -euo pipefail

__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )
_timestamp="$(date +'%d%m%y_%H%M%S')"

DATASET_KEY="${1:-100-driver-day-cam2-sf3d-nc10-bbox}"
SPLITS="${2:-train val test}"
WEIGHTS="${3:-yolov8s-seg.pt}"     # segmentation model
CFG="${4:-data/ddd-datasets.yml}"
CONF="${5:-0.35}"
IOU="${6:-0.45}"
PERSON_ID="${7:-0}"
FLOW="${8:-simple}"                # simple | bboxseg
SAMPLE_LIMIT=0

args=( "--dataset=${DATASET_KEY}" )
args+=( "--datasetcfg=${CFG}" )
args+=( "--splits" ${SPLITS} )
args+=( "--weights_path=${WEIGHTS}" )
args+=( "--device=cuda" )
args+=( "--imgsz=640" )
args+=( "--flow=${FLOW}" )
args+=( "--prefer-class=${PERSON_ID}" )
args+=( "--conf_thres=${CONF}" )
args+=( "--iou_thres=${IOU}" )
args+=( "--sample_limit=${SAMPLE_LIMIT}" )
args+=( "--save-mask-png" )
args+=( "--viz" )

python -m src.anonflow "${args[@]}"
