#!/bin/bash

## __author__="XYZ"
## ----------------------------------------------------------
## Runner script for standalone rflow.py execution tests

set -euo pipefail

__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}")" && pwd )
_timestamp="$(date +'%d%m%y_%H%M%S')"

## -----------------------------------------------------------------
## Params (override on CLI if needed)
## -----------------------------------------------------------------
FLOW="${1:-simple}"       # which test__<> flow to run, e.g., simple / chain / custom
DEVICE="${2:-cpu}"        # cpu or cuda
SEED="${3:-42}"           # random seed for reproducibility

## -----------------------------------------------------------------
## Build args array
## -----------------------------------------------------------------
args=( "--flow=${FLOW}" )
args+=( "--device=${DEVICE}" )
args+=( "--seed=${SEED}" )

## -----------------------------------------------------------------
## Run rflow
## -----------------------------------------------------------------
python -m src.rflow "${args[@]}"
