#!/bin/bash

## __author__="XYZ"
## ----------------------------------------------------------
## Test harness for clustering module (different scenarios)

set -euo pipefail

__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}")" && pwd )
_timestamp="$(date +'%d%m%y_%H%M%S')"

BASE_DIR="${1:-${__CODEHUB_ROOT__}/external/rflownet/logs/sage-220925_211931}"
DNNARCH="${2:-efficientnet_b0}"
RESNET="${3:-resnet18}"

echo "==========================================================="
echo ">>> [Test 1] Cluster ALL models under base dir"
echo "==========================================================="
bash ${__LSCRIPTS}/cluster.sh "${BASE_DIR}" KMeans 4 "" true

echo
echo "==========================================================="
echo ">>> [Test 2] Cluster only one model dir (${DNNARCH}) with KMeans (6 clusters)"
echo "==========================================================="
bash ${__LSCRIPTS}/cluster.sh "${BASE_DIR}/${DNNARCH}" KMeans 6 "" false

echo
echo "==========================================================="
echo ">>> [Test 3] Cluster only one model dir (${RESNET}) with DBSCAN (default params)"
echo "==========================================================="
bash ${__LSCRIPTS}/cluster.sh "${BASE_DIR}/${RESNET}" DBSCAN "" false

echo
echo "==========================================================="
echo ">>> [Test 4] Cluster only one model dir (${RESNET}) with DBSCAN (eps=0.3, min_samples=5)"
echo "==========================================================="
bash ${__LSCRIPTS}/cluster.sh "${BASE_DIR}/${RESNET}" DBSCAN 0 '{"eps":0.3,"min_samples":5}' false

echo
echo "==========================================================="
echo ">>> [Test 5] Cluster only one model dir (${DNNARCH}) with KMeans (custom n_clusters via JSON)"
echo "==========================================================="
bash ${__LSCRIPTS}/cluster.sh "${BASE_DIR}/${DNNARCH}" KMeans 0 '{"n_clusters":8,"random_state":123}' false

echo
echo "==========================================================="
echo "All cluster tests completed. Logs saved under clusters/ dirs."
echo "==========================================================="
