#!/bin/bash

## __author__="XYZ"
## ----------------------------------------------------------
## Runner script for saliency generation on clustered inference outputs
## NOTE: This script passes *all* arguments unconditionally; Python handles logic.
## Extended to support saving per-cell patches for tokens (--save_patches, --patch_out_hw)
## ----------------------------------------------------------

set -euo pipefail

__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}")" && pwd )
_timestamp="$(date +'%d%m%y_%H%M%S')"

BASE_DIR="${1:-${__CODEHUB_ROOT__}/external/rflownet/logs/sage-230925_091907}"
NET="${2:-resnet18}"
WEIGHTS_PATH="${3:-auto}"
NUM_CLASS="${4:-10}"
INPUT_SIZE="${5:-(224,224)}"

METHODS="${6:-GradCAM LayerCAM EigenCAM}"
NORMALIZE="${7:-phi_relu}"
MASK_MODE="${8:-runtime}"                 ## default ON (runtime YOLO)
GRIDS="${9:-4x4 8x8}"

LOSS="${10:-CrossEntropyLoss}"
SCORE_LEVEL="${11:-1}"
IN_CHANNELS="${12:-3}"
PRETRAIN="${13:-false}"

GPU="${14:-true}"

YOLO_WEIGHTS="${15:-/codehub/external/rflownet/yolov8s-seg.pt}"
YOLO_IMGSZ="${16:-640}"
YOLO_CONF="${17:-0.25}"
YOLO_IOU="${18:-0.45}"
YOLO_PREFER_CLASS="${19:-0}"
SAVE_RUNTIME_MASKS="${20:-true}"          ## save *.mask.png alongside images

NO_TOKENS="${21:-false}"
CLASS_PREFIX_REGEX="${22:-^c[0-9]+$}"
CAM_BATCH_SIZE="${23:-16}"
FAIL_FAST="${24:-false}"

## new: which parts to emit (Python filters gracefully)
PARTS="${25:-whole fg bg}"

## new: where to WRITE saliency; groups still read from ${BASE_DIR}/${NET}
SAL_LAYOUT="${26:-saliency/<arch>}"       ## kept for future toggles

## NEW: patch saving controls (positional 27 & 28)
## SAVE_PATCHES: true|false (default true)
## PATCH_OUT_HW: e.g. "(32,32)" (default (32,32))
SAVE_PATCHES="${27:-true}"
PATCH_OUT_HW="${28:-(32,32)}"

args=( "--net=${NET}"
       "--weights_path=${WEIGHTS_PATH}"
       "--num_class=${NUM_CLASS}"
       "--input_size=${INPUT_SIZE}"
       "--to=${BASE_DIR}"

       "--methods" ${METHODS}
       "--normalize" ${NORMALIZE}
       "--mask_mode=${MASK_MODE}"
       "--grids" ${GRIDS}

       "--loss=${LOSS}"
       "--score_level=${SCORE_LEVEL}"
       "--in_channels=${IN_CHANNELS}"
       "--pretrain=${PRETRAIN}"

       "--gpu=${GPU}"

       "--yolo_weights=${YOLO_WEIGHTS}"
       "--yolo_imgsz=${YOLO_IMGSZ}"
       "--yolo_conf=${YOLO_CONF}"
       "--yolo_iou=${YOLO_IOU}"
       "--yolo_prefer_class=${YOLO_PREFER_CLASS}"
       "--save_runtime_masks=${SAVE_RUNTIME_MASKS}"

       # tokens / patchify
       "--no_tokens=${NO_TOKENS}"
       "--save_tokens=true"
       "--save_patches=${SAVE_PATCHES}"
       "--patch_out_hw=${PATCH_OUT_HW}"

       "--class_prefix_regex=${CLASS_PREFIX_REGEX}"
       "--parts" ${PARTS}

       "--cam_batch_size=${CAM_BATCH_SIZE}"
       "--fail_fast=${FAIL_FAST}" )

python -m src.saliency "${args[@]}"
