#!/bin/bash

##__author__ = 'XYZ'
###----------------------------------------------------------


__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}")" && pwd )

declare -A nets

nets=(
  ["densenet121"]='(224,224)'
  # ["densenet161"]='(224,224)'
  # ["densenet169"]='(224,224)'
  # ["densenet201"]='(224,224)'
  ["efficientnet_b0"]='(224,224)'
  # ["inception_v3"]='(299,299)'
  # ["mobilenet_v2"]='(224,224)'
  # ["mobilenet_v3_large"]='(224,224)'
  # ["mobilenet_v3_small"]='(224,224)'
  # ["resnet101"]='(224,224)'
  # ["resnet152"]='(224,224)'
  ["resnet18"]='(224,224)'
  # ["resnet34"]='(224,224)'
  ["resnet50"]='(224,224)'
  # ["shufflenet_v2_x1_0"]='(224,224)'
  ["squeezenet1_0"]='(224,224)'
  # ["vgg11"]='(224,224)'
  # ["vgg11_bn"]='(224,224)'
  # ["vgg13"]='(224,224)'
  # ["vgg13_bn"]='(224,224)'
  # ["vgg16"]='(224,224)'
  # ["vgg16_bn"]='(224,224)'
  # ["vgg19"]='(224,224)'
  # ["vgg19_bn"]='(224,224)'
  # ["wide_resnet101_2"]='(224,224)'
  # ["wide_resnet50_2"]='(224,224)'
)

## dataset
# dataset="sf3d-day-byimage"
# dataset="100-driver-day-cam2-sf3d-nc10"
dataset="100-driver-day-cam2-sf3d-nc10-bbox"
# dataset="100-driver-day-cam2-sf3d-nc10-seg"
# dataset="100-driver-day-cam2-sf3d-nc10-mask"
# dataset="100-driver-day-cam2-sf3d-nc10-bboxseg"
num_class=10
loss="CrossEntropyLoss"
# loss="ScoreLossPlus"
score_level=10
# score_level=5
## training time configurations
epochs=${1:-100}
## batch_size: 32,64, 128
batch_size=${2:-32}

# ## test configuration - comment it for full training schedule
# epochs=1
# batch_size=1
# sample_limit=100

__timestamp__=${1:-$(date -d now +'%d%m%y_%H%M%S')}
## Loop over associative array
for dnnarch in "${!nets[@]}"; do
  timestamp=${1:-$(date -d now +'%d%m%y_%H%M%S')}
  # timestamp="131124_141434"

  input_size="${nets[$dnnarch]}"
  to_path="${__DATAHUB_ROOT__}/logs/train-${loss}_${score_level}-${__timestamp__}/${dnnarch}-bs${batch_size}-nc${num_class}-${dataset}-${timestamp}"
  log_filepath="${to_path}/${dnnarch}-bs${batch_size}-nc${num_class}-${dataset}-${loss}_${score_level}-${timestamp}.log"
  mkdir -p ${to_path}

  echo "timestamp:: ${timestamp}"
  echo "net (dnnarch):: ${dnnarch}"
  echo "to_path (to):: ${to_path}"
  echo "input_size:: ${input_size}"
  echo "dataset:: ${dataset}"
  echo "num_class:: ${num_class}"
  echo "loss:: ${loss}"
  echo "score_level:: ${score_level}"
  echo "epochs:: ${epochs}"
  echo "batch_size:: ${batch_size}"
  # echo "sample_limit:: ${sample_limit}"
  echo "log_filepath:: ${log_filepath}"


  python -m src.train \
    --net "${dnnarch}" \
    --to "${to_path}" \
    --input_size ${input_size} \
    --dataset ${dataset} \
    --num_class ${num_class} \
    --loss ${loss} \
    --score_level ${score_level} \
    --epochs ${epochs} \
    --batch_size ${batch_size} \
    --pretrain \
    --gpu 2>&1 | tee "${log_filepath}"

  # python -m src.train --net ${dnnarch} --dataset ${dataset} --batch_size ${batch_size} --epochs ${epochs} --to ${to_path} --input_size ${input_size} --sample_limit 100

  # weights_path="${to_path}/${dnnarch}-best.pth"

  # echo "Processing architecture: ${dnnarch}"
  # echo "To path: ${to_path}"
  # echo "Weights path: ${weights_path}"

  # ## Check if weights file exists and continue only if it does
  # [ ! -f "${weights_path}" ] && echo "Error: Weights file ${weights_path} does not exist!" && continue

  # # ## Create the output directory if it doesn't exist
  # # mkdir -p "${to_path}"

  # ## Run the Python inspect module with the given parameters
  # python -m src.inspect \
  #   --net "${dnnarch}" \
  #   --to "${to_path}" \
  #   --input_size "${input_size}" \
  #   --weights_path "${weights_path}" \
  #   --num_class "${num_class}"
done
