"""color utilityies for cli and otherwise."""
__author__ = 'XYZ'

import os
import colorsys
import random
import sys

this = sys.modules[__name__]


if (sys.version_info >= (3, 7)):
  if os.name == 'nt':
    try:
      ## This introduces python dependency of 3.7+
      from colorama import just_fix_windows_console
      just_fix_windows_console()
    except ImportError:
      pass  # Handle the ImportError if colorama is not installed on Windows


nocolor = '\033[0m'  # text reset

# -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# regular                bold                      underline                high intensity             boldhigh intens           background                high intensity backgrounds
# -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
bla, bbla, ubla, ibla, bibla, on_bla, on_ibla = (
    '\033[0;30m',
    '\033[1;30m',
    '\033[4;30m',
    '\033[0;90m',
    '\033[1;90m',
    '\033[40m',
    '\033[0;100m',
)
red, bred, ured, ired, bired, on_red, on_ired = (
    '\033[0;31m',
    '\033[1;31m',
    '\033[4;31m',
    '\033[0;91m',
    '\033[1;91m',
    '\033[41m',
    '\033[0;101m',
)
gre, bgre, ugre, igre, bigre, on_gre, on_igre = (
    '\033[0;32m',
    '\033[1;32m',
    '\033[4;32m',
    '\033[0;92m',
    '\033[1;92m',
    '\033[42m',
    '\033[0;102m',
)
yel, byel, uyel, iyel, biyel, on_yel, on_iyel = (
    '\033[0;33m',
    '\033[1;33m',
    '\033[4;33m',
    '\033[0;93m',
    '\033[1;93m',
    '\033[43m',
    '\033[0;103m',
)
blu, bblu, ublu, iblu, biblu, on_blu, on_iblu = (
    '\033[0;34m',
    '\033[1;34m',
    '\033[4;34m',
    '\033[0;94m',
    '\033[1;94m',
    '\033[44m',
    '\033[0;104m',
)
pur, bpur, upur, ipur, bipur, on_pur, on_ipur = (
    '\033[0;35m',
    '\033[1;35m',
    '\033[4;35m',
    '\033[0;95m',
    '\033[1;95m',
    '\033[45m',
    '\033[0;105m',
)
cya, bcya, ucya, icya, bicya, on_cya, on_icya = (
    '\033[0;36m',
    '\033[1;36m',
    '\033[4;36m',
    '\033[0;96m',
    '\033[1;96m',
    '\033[46m',
    '\033[0;106m',
)
whi, bwhi, uwhi, iwhi, biwhi, on_whi, on_iwhi = (
    '\033[0;37m',
    '\033[1;37m',
    '\033[4;37m',
    '\033[0;97m',
    '\033[1;97m',
    '\033[47m',
    '\033[0;107m',
)


def text(s='', cc=bigre, es=''):
  return cc + s + nocolor + es


def cprint(s='', cc=bigre, es=''):
  print(cc + s + nocolor + es)


def echo(s='', cc='byel', es=''):
  _cc = getattr(this, cc)
  print(_cc + s + nocolor + es)


def random_colors(N, bright=True):
  """Generate random colors.

  To get visually distinct colors, generate them in HSV space then
  convert to RGB.
  """
  brightness = 1.0 if bright else 0.7
  hsv = [(i / N, 1, brightness) for i in range(N)]
  colors = list(map(lambda c: colorsys.hsv_to_rgb(*c), hsv))
  random.shuffle(colors)
  return colors


def colorstr(*input):
  # Colors a string https://en.wikipedia.org/wiki/ANSI_escape_code, i.e.  colorstr('blue', 'hello world')
  *args, string = input if len(input) > 1 else ('blue', 'bold', input[0])  # color arguments, string
  colors = {
    'black': '\033[30m',  # basic colors
    'red': '\033[31m',
    'green': '\033[32m',
    'yellow': '\033[33m',
    'blue': '\033[34m',
    'magenta': '\033[35m',
    'cyan': '\033[36m',
    'white': '\033[37m',
    'bright_black': '\033[90m',  # bright colors
    'bright_red': '\033[91m',
    'bright_green': '\033[92m',
    'bright_yellow': '\033[93m',
    'bright_blue': '\033[94m',
    'bright_magenta': '\033[95m',
    'bright_cyan': '\033[96m',
    'bright_white': '\033[97m',
    'end': '\033[0m',  # misc
    'bold': '\033[1m',
    'underline': '\033[4m'
  }
  return ''.join(colors[x] for x in args) + f'{string}' + colors['end']
