"""encoders for computer vision workflows and pipelines."""
__author__ = 'XYZ'

import json

from .numpyencoder import NumpyEncoder


def numpy_to_json(json_input):
  """As Numpy Array Is Not Json serializable, it converts the numpy array to
  serialiazable json string It uses the custom class: NumpyEncoder.

  References:
  * https://stackoverflow.com/questions/17043860/python-dump-dict-to-json-file
  * https://stackoverflow.com/questions/32468278/list-as-an-entry-in-a-dict-not-json-serializable
  * https://stackoverflow.com/questions/26646362/numpy-array-is-not-json-serializable
  """

  json_str = json.dumps(json_input, cls=NumpyEncoder)
  # json_str = json.dumps(json_input, cls=NumpyEncoder, indent=2)
  return json_str
