"""Special json encoder for numpy types.
"""
__author__ = 'XYZ'


import datetime
import json

import numpy as np


class NumpyEncoder(json.JSONEncoder):
  """Special json encoder for numpy types.

  References:
  * https://stackoverflow.com/questions/26646362/numpy-array-is-not-json-serializable
  * https://stackoverflow.com/questions/50916422/python-typeerror-object-of-type-int64-is-not-json-serializable
  """

  def default(self, obj):
    if isinstance(obj, np.integer):
      return int(obj)
    elif isinstance(
        obj,
        (
            np.int_,
            np.intc,
            np.intp,
            np.int8,
            np.int16,
            np.int32,
            np.int64,
            np.uint8,
            np.uint16,
            np.uint32,
            np.uint64,
        ),
    ):
      return int(obj)
    elif isinstance(obj, (np.float_, np.float16, np.float32, np.float64)):
      return float(obj)
    elif isinstance(obj, (np.ndarray,)):
      return obj.tolist()
      # caution:: recursion, check if requried
      # return default(obj.tolist())
    elif isinstance(obj, (np.bool_)):
      return bool(obj)
    elif isinstance(obj, (np.void)):
      return None
    elif isinstance(obj, datetime.datetime):
      # return obj.__str__()
      return obj.isoformat()
    return json.JSONEncoder.default(self, obj)
