## Dataset variant creation for `sf3d-day-bydriver`

```bash
bash scripts/anonflow.sf3d-day-bydriver.yolov8s-seg.sh
```


```bash
logs/annotate-<ddmmyy_hhmmss>/
├── sf3d-day-bydriver-annotation
├── sf3d-day-bydriver-bbox
├── sf3d-day-bydriver-mask
├── sf3d-day-bydriver-seg
├── sf3d-day-bydriver-viz
├── modelinfo.json
├── summary.json
├── test
│    ├── imgs_list.csv
│    ├── labels.csv
│    ├── summary.json
│    ├── summary.missed.json
│    └── test.csv
├── train
│    ├── imgs_list.csv
│    ├── labels.csv
│    ├── summary.json
│    ├── summary.missed.json
│    └── train.csv
└── val
    ├── imgs_list.csv
    ├── labels.csv
    ├── summary.json
    ├── summary.missed.json
    └── val.csv
```

Customise the script to create the required symlinks

```bash
vi scripts/datasets/sf3d.symlinks.sh
```

Add the entry for `bbox` and `seg` variant in the `data/ddd-datasets.yml` configuration.

```yml
sf3d-day-bydriver-seg:
  loadertxt: sf3d/imgs/sf3d-day-bydriver-seg
  valloadertxt: sf3d/data-splits/by-driver/val.txt
  testloadertxt: sf3d/data-splits/by-driver/test.txt
  trainloadertxt: sf3d/data-splits/by-driver/train.txt
sf3d-day-bydriver-bbox:
  valloadertxt: sf3d/data-splits/by-driver/val.txt
  testloadertxt: sf3d/data-splits/by-driver/test.txt
  trainloadertxt: sf3d/data-splits/by-driver/train.txt
```

Re-generate the train/val/test indices as all the images may not have the inference or error and may have fallen off.

* Open the script `scripts/regen_loadertxt.sh` and update the dataset-id for which the indices have to be regerate it, save it.


```bash
vi scripts/regen_loadertxt.sh
```

*  Execute the script.

```bash
bash scripts/regen_loadertxt.sh
```

* Copy the regenerated indices in required dataset split paths. Update the index entry for `bbox` and `seg` variant in the `data/ddd-datasets.yml` configuration for respective dataset-id. Final configuration, should look like below. These already exists in current configuration and you may need to tweak it when generating the dataset variant at your end.

```yml
sf3d-day-bydriver-seg:
  loadertxt: sf3d/imgs/sf3d-day-bydriver-seg
  valloadertxt: sf3d/imgs/sf3d-day-bydriver-seg/val.txt
  testloadertxt: sf3d/imgs/sf3d-day-bydriver-seg/test.txt
  trainloadertxt: sf3d/imgs/sf3d-day-bydriver-seg/train.txt
sf3d-day-bydriver-bbox:
  loadertxt: sf3d/imgs/sf3d-day-bydriver-bbox
  valloadertxt: sf3d/imgs/sf3d-day-bydriver-bbox/val.txt
  testloadertxt: sf3d/imgs/sf3d-day-bydriver-bbox/test.txt
  trainloadertxt: sf3d/imgs/sf3d-day-bydriver-bbox/train.txt
```

To create bbox guided segmentation (bboxseg) variant, use previous generated `bbox` dataset variant as the input dataset, keep the rest of the configuration same as used in previous variant. The dataset should already be confiured in `data/ddd-datasets.yml` configuration file.
```bash
bash scripts/anonflow.sf3d-day-bydriver-bbox.yolov8s-seg.sh
```

Add the dataset in the dataset configuration file as the `bboxseg` variant, create symlinks/copy data. Repeat the regenration of index step; post re-generation of the indices, copy the indecies to respective dataset directory, re-configure the dataset configuration to point to the newly generated indices. Failing to do so, the images not present will show as annoying errors but training will still happen.

```yml
sf3d-day-bydriver-bboxseg:
  loadertxt: sf3d/imgs/sf3d-day-bydriver-bboxseg
  valloadertxt: sf3d/imgs/sf3d-day-bydriver-bboxseg/val.txt
  testloadertxt: sf3d/imgs/sf3d-day-bydriver-bboxseg/test.txt
  trainloadertxt: sf3d/imgs/sf3d-day-bydriver-bboxseg/train.txt
```


## Dataset labels

dataset_label - is the actual label being used to store the image files

```csv
id,dataset_label,name
c0,c0,normal_driving
c1,c1,texting_right
c2,c2,talking_on_the_phone_right
c3,c3,texting_left
c4,c4,talking_on_the_phone_left
c5,c5,operating_the_radio
c6,c6,drinking
c7,c7,reaching_behind
c8,c8,hair_and_makeup
c9,c9,talking_to_passenger
```

## Dataset Directory Structure

```bash
├── data-splits
│ ├── by-driver
│ │ └── plots-datasets
│ └── by-image
│     └── plots-datasets
└── imgs
    ├── annotate-bbox-160925_171044
    │ ├── sf3d-day-bydriver-annotation
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── sf3d-day-bydriver-bbox
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── sf3d-day-bydriver-mask
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── sf3d-day-bydriver-seg
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── sf3d-day-bydriver-viz
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── test
    │ ├── train
    │ └── val
    ├── annotate-bboxseg-170925_145659
    │ ├── sf3d-day-bydriver-annotation
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── sf3d-day-bydriver-bbox
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── sf3d-day-bydriver-mask
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── sf3d-day-bydriver-seg
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── sf3d-day-bydriver-viz
    │ │ ├── c0
    │ │ ├── c1
    │ │ ├── c2
    │ │ ├── c3
    │ │ ├── c4
    │ │ ├── c5
    │ │ ├── c6
    │ │ ├── c7
    │ │ ├── c8
    │ │ └── c9
    │ ├── test
    │ ├── train
    │ └── val
    ├── sf3d-day-bydriver-bbox -> annotate-bbox-160925_171044/sf3d-day-bydriver-bbox
    ├── sf3d-day-bydriver-bboxseg -> annotate-bboxseg-170925_145659/sf3d-day-bydriver-seg
    ├── sf3d-day-bydriver-mask -> annotate-bboxseg-170925_145659/sf3d-day-bydriver-mask
    ├── sf3d-day-bydriver-seg -> annotate-bbox-160925_171044/sf3d-day-bydriver-seg
    ├── test
    └── train-fullbg
        ├── c0
        ├── c1
        ├── c2
        ├── c3
        ├── c4
        ├── c5
        ├── c6
        ├── c7
        ├── c8
        └── c9

140 directories
```

## Dataset Storage

```bash
# du -h --max-depth=1 | sort -h
5.2M  ./data-splits
14G ./imgs
```

```bash
# du -h --max-depth=2 | sort -h
2.6M  ./data-splits/by-image
2.7M  ./data-splits/by-driver
5.2M  ./data-splits
952M  ./imgs/train-fullbg
3.3G  ./imgs/test
4.5G  ./imgs/annotate-bboxseg-170925_145659
4.6G  ./imgs/annotate-bbox-160925_171044
```
