#!/bin/bash

## __author__="XYZ"
## ----------------------------------------------------------
## Runner script for clustering analysis on inference outputs

set -euo pipefail

__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}")" && pwd )
_timestamp="$(date +'%d%m%y_%H%M%S')"

BASE_DIR="${1:-${__CODEHUB_ROOT__}/external/rflownet/logs/sage-220925_211931}"
METHOD="${2:-KMeans}"
COUNT="${3:-4}"
CLUSTER_PARAMS="${4:-}"
ALL="${5:-true}"

args=( "--from=${BASE_DIR}" )
args+=( "--method=${METHOD}" )
args+=( "--count=${COUNT}" )

if [ -n "${CLUSTER_PARAMS}" ]; then
  args+=( "--cluster-params=${CLUSTER_PARAMS}" )
fi

if [ "${ALL}" = true ]; then
  args+=( "--all" )
fi

python -m src.cluster "${args[@]}"
