#!/bin/bash

##__author__='XYZ'
###----------------------------------------------------------

set -euo pipefail

__LSCRIPTS=$( cd "$( dirname "${BASH_SOURCE[0]}")" && pwd )
_timestamp="$(date +'%d%m%y_%H%M%S')"

# DATASET="${1:-100-driver-day-cam2-sf3d-nc10-bboxseg}"
# DATASET="${1:-100-driver-day-cam2-sf3d-nc10-seg}"
DATASET="${1:-100-driver-day-cam2-sf3d-nc10-bbox}"
# DATASET="${1:-sf3d-day-bydriver-bboxseg}"
# DATASET="${1:-sf3d-day-bydriver-seg}"
# DATASET="${1:-sf3d-day-bydriver-mask}"
# DATASET="${1:-sf3d-day-bydriver-bbox}"
CFG="${2:-data/ddd-datasets.yml}"
SPLITS="${3:-train val test}"
FROM_PATH="${4:-}"

args=( "--dataset=${DATASET}" )
args+=( "--datasetcfg=${CFG}" )
args+=( "--splits" ${SPLITS} )
[ -n "${FROM_PATH}" ] && args+=( "--from=${FROM_PATH}" )

python -m src.regen_loadertxt "${args[@]}"
