import torch
import torch.nn as nn
import torch.nn.functional as F
import torch.optim as optim
from torch.utils.data import DataLoader
torch.manual_seed(123)
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

mse = nn.MSELoss()

def seq_maker(num_hidden,num_layer,num_output=2,num_input=1,dropout=1):
  layers=[nn.Linear(num_input,num_hidden)]
  for _ in range(num_layer):
    layers.append(nn.ReLU())
    if _ != num_layer-1:
      if dropout != 1:
        layers.append(nn.Dropout(p=dropout))
      layers.append(nn.Linear(num_hidden,num_hidden))
    else:
      layers.append(nn.Linear(num_hidden,num_output))
  return nn.Sequential(*layers)

def eval_loader_nn(model,loader,device):
  loss = []
  for data in loader:
    x, y1,y2 = data
    x = x.to(device)
    output= model(x)

    loss.append(mse(output,torch.cat([y1,y2],dim=1).to(device)).item())

  return torch.mean(torch.tensor(loss))
