# Floco

The `./src` directory contains all source code; configs are stored in `./configs`.

## Installation

Create a virtual environment and install the dependencies:
```
python -m venv venv
. venv/bin/activate
pip install --upgrade pip
pip install -r requirements.txt
```

## Prepare datasets

CIFAR-10 will be downloaded automatically on first invocation. To run FEMNIST experiments, first run
```
mkdir Data
cd Data
git clone https://github.com/TalwalkarLab/leaf.git
cd leaf/data/femnist
./preprocess.sh -s niid --sf 1.0 -k 0 -t sample
```

## Usage


To execute experiments, run
```
python main.py dataset_model=<DATASET_MODEL> rule=<RULE> strategy=<STRATEGY>
```
where
- `<DATASET_MODEL>` is one of "cifar10_simplecnn", "cifar10_pretrained_resnet18", "femnist_simplecnn", "femnist_pretrained_squeezenet"
- `<RULE>` is one of "dir_05", "five_fold", "femnist" (natural non-IID split for FEMNIST dataset)
- `<STRATEGY>` is one of "fedavg", "fedprox", "ditto", "floco", "floco_p" (FLOCO+ which combines FLOCO and Ditto)

We use [hydra](https://hydra.cc/) for configration management, so all parameters can be overwritten via command line arguments.

### Example

Example for reproducing FLOCO vs. FedAvg on CIFAR-10 with Dir(0.5) split on the pre-trained ResNet-18:
```
python main.py -m dataset_model=cifar10_pretrained_resnet18 rule=dir_05 strategy=fedavg,floco
```
