import anthropic
import json
import csv

client = anthropic.Anthropic(
    api_key="",
)


def has_english_characters(s):
    for char in s:
        if char.isalpha():
            return True
    return False


def process_api_response_english(response):
    options = []
    lines = response.strip().split('\n')
    for line in lines:
        parts = line.split(': ')
        option = parts[1].strip()
        options.append(option)
    return options


def process_api_response(response):
    if ',' in response and ' ' not in response:
        return response.strip().split(',')

    options = []
    if ' ' in response:
        if '\n' in response:
            lines = response.strip().split('\n')
            for line in lines:
                parts = line.split('. ')
                option = parts[1].strip()
                options.append(option)
            return options
        return response.strip().split(', ')
    return None


def answer_multiple_choice_questions(questions):
    prompt_eos = ""
    prompt = ("Please answer the following multiple-choice questions. Give options directly.")

    for idx, q in enumerate(questions):
        question = q['question']
        distractor1 = q['distractor1']
        distractor2 = q['distractor2']
        distractor3 = q['distractor3']
        correct_answer = q['correct_answer']
        options = [distractor1, distractor2, distractor3, correct_answer]

        prompt += f"Question{idx + 1}: {question}\nOptions:\n"
        for index, option in enumerate(options, start=1):
            prompt += f"{index}. {option}\n"
        prompt += f"answer{idx + 1}:?\n"

        if idx < len(questions) - 1:
            prompt_eos += f"answer{idx + 1}:,"
        else:
            prompt_eos += f"answer{idx + 1}:"

    response = client.messages.create(
        model="ChatGLM2-6B-32K, ChatGPT-3.5, ChatGPT-4, ERNIE-3.5-8K, llama2_7b, llama2_13b, llama2_70b, Mixtral,claude-2.0",
        max_tokens=300,
        messages=[
            {"role": "user", "content": prompt}
        ]
    )

    rewards = []

    for idx, q in enumerate(questions):

        try:
            if response.content[0].text.strip() == "":
                rewards = [3, 3, 3, 3, 3]
                break
            if has_english_characters(response.content[0].text.strip()):
                ans = process_api_response_english(response.content[0].text.strip())
                if ans[idx] == '4':
                    rewards = [5, 5, 5, 5, 5]
                else:
                    rewards = [3, 3, 3, 3, 3]
                break
            else:
                ans = process_api_response(response.content[0].text.strip())
            if ans is None:
                rewards = [1, 1, 1, 1, 1]

            if ans[idx] == '4':
                rewards.append(5)
            else:
                rewards.append(0)
        except Exception as e:
            rewards = [0, 0, 0, 0, 0]

    return rewards




if __name__ == "__main__":
    with open('C:\\Users\\Desktop\\SciQ\\SciQ dataset-2 3\\valid.json', 'r') as file:
        sciq_data = json.load(file)

    with open('C:\\Users\\Desktop\\results_claude2.0.csv', 'a', newline='') as csvfile:
        fieldnames = ['question_id', 'api_id', 'rating', 'budget']
        writer = csv.DictWriter(csvfile, fieldnames=fieldnames)
        if csvfile.tell() == 0:
            writer.writeheader()

        for idx in range(0, len(sciq_data), 50):
            questions = sciq_data[idx:idx + 50]
            reward = answer_multiple_choice_questions(questions)
            for r in reward:
                idx += 1
                writer.writerow({'question_id': idx, 'api_id': 0, 'rating': r, 'budget': 0})