import gurobipy as gp
from gurobipy import GRB
import numpy as np



def solve_constrain(L,K,C,a,w):
    tmp_ones = np.ones(L)
    model = gp.Model()
    model.setParam('OutputFlag', 0)
    x = [[] for i in range(L)]
    for i in range(L):
        x[i] = model.addVar(lb=0.0, ub=1.0, vtype=GRB.CONTINUOUS, name="x_{}".format(i))


    expr = gp.LinExpr(0)
    for i in range(L):
        expr.addTerms(a[i], x[i])
    model.setObjective(expr, sense=GRB.MAXIMIZE)
    model.addConstr(gp.quicksum(x) == K)
    expr = gp.LinExpr(0)
    for i in range(L):
        expr.addTerms(w[i], x[i])
    model.addConstr(expr <= C)

    for i in range(L):
        expr = gp.LinExpr(0)
        expr.addTerms(tmp_ones[i], x[i])
        model.addConstr(expr <=1)
        model.addConstr(expr >=0)
    model.optimize()

    result = np.zeros(L)
    tmp = 0
    for var in model.getVars():

        result[tmp] = var.x
        tmp +=1
    
    # print("result++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",result)

    return result

