import gurobipy as gp
from gurobipy import GRB
import numpy as np



def convex_representation(K,fractional_solution):
    x = fractional_solution
    n = len(fractional_solution)
    k = K
    model = gp.Model()
    model.setParam('OutputFlag', 0)
    model.setObjective(0, sense=GRB.MINIMIZE)
    beta = [[] for i in range(n)]
    B = [[[] for i in range(n)] for j in range(n)]
    for i in range(n):
        beta[i] = model.addVar(lb=0, ub=1, vtype=GRB.CONTINUOUS, name="beta_{}".format(i))
    for i in range(n):
        for j in range(n):
            B[i][j] = model.addVar(vtype=GRB.BINARY, name="B_{},{}".format(i, j))

    for i in range(n):
        expr = gp.LinExpr(0)
        for j in range(n):
            expr.addTerms(1, B[j][i])
        model.addConstr(expr <= k)

    model.addConstr(gp.quicksum(beta) == 1)
    for j in range(n):
        expr = gp.QuadExpr(0)
        for i in range(n):
            expr += beta[i] * B[j][i]
        model.addConstr(expr == x[j])

    model.optimize()

    beta_new= np.zeros(n) 
    y = np.zeros((n, n))
    tmp = 0
    for var in model.getVars():
        if var.varName[0] == 'b':
            beta_new[tmp]=var.x
            tmp +=1
        if(var.x > 0 and var.varName[0] == "B"):
            a, b = var.varName.split(',')
            y[int(a[2:]), int(b)] = var.x

    nonzero_index = np.flatnonzero(beta_new)
    y_final = np.zeros((n,len(nonzero_index)))
    beta_final = np.zeros(len(nonzero_index))
    for i in range(len(nonzero_index)):
        y_final[:,i] = y[:,nonzero_index[i]]
        beta_final[i] = beta_new[nonzero_index[i]]
    return beta_final,y_final

