import gurobipy as gp
from gurobipy import GRB
import numpy as np

# np.random.seed(11215)
# L = 5
# K = 3
# C = 0.5
# w = np.random.uniform(0, 1, L)
# a = np.random.uniform(0, 1, L)

def find_optimal_min(L,K,C,a,w):
    model = gp.Model()
    model.setParam('OutputFlag', 0)
    x = [[] for i in range(L)]
    for i in range(L):
        x[i] = model.addVar(lb=0, ub=1, vtype=GRB.BINARY, name="x_{}".format(i))

    expr = gp.LinExpr(0)
    for i in range(L):
        expr.addTerms(a[i], x[i])
    model.setObjective(expr, sense=GRB.MINIMIZE)
    model.addConstr(gp.quicksum(x) <= K)
    expr = gp.LinExpr(0)
    for i in range(L):
        expr.addTerms(w[i], x[i])
    model.addConstr(expr <= C)

    model.optimize()
    optimal_result = np.zeros(L)
    tmp = 0
    for var in model.getVars():
        optimal_result[tmp] = var.x
        tmp+=1
    return optimal_result
