# README

## Introduction

The C2MAB-V requires the integration of several tools and datasets, including Gurobi 11.0.1, the latest version of NumPy, and the SciQ dataset. Additionally, specific API keys must be configured, and cost parameters should be dynamically set based on the relevant API pricing.

## Prerequisites

### Software Requirements

1. **Gurobi Optimizer 11.0.1**: Ensure you have Gurobi 11.0.1 installed. Gurobi is a state-of-the-art mathematical optimization solver required for executing the computational tasks within this project.

    - Installation instructions can be found on the [Gurobi website](https://www.gurobi.com/documentation/11.0/quickstart.html).

2. **NumPy**: The project requires the latest version of NumPy. NumPy is essential for numerical operations and data manipulation.

    ```bash
    pip install numpy --upgrade
    ```

### Dataset

- **SciQ Dataset**: The questions for the project are sourced from the SciQ dataset. Ensure the dataset is downloaded and accessible within the project directory.
- Download the dataset from the [SciQ repository](https://allenai.org/data/sciq).

## Setup Instructions

### API Configuration

- **get_api_mu.py**: You need to manually add your API key to the `get_api_mu.py` file. This key is necessary for accessing the external services used in this project.

    ```python
    # get_api_mu.py
    api_key = 'your_api_key_here'
    ```

### Cost Parameters

- **Dynamic Cost Setting**: The `cost` parameter should be set based on the specific pricing of the API being utilized. Refer to the API provider's pricing documentation to accurately set this value.

    ```python
    # Example code snippet
    cost = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6]
    ```

## Troubleshooting

- **Gurobi Installation Issues**: Refer to the Gurobi documentation or contact Gurobi support for assistance.
- **API Key Errors**: Verify that the API key is correctly added in `get_api_mu.py` and that it has the necessary permissions.
- **Cost Parameter Misconfigurations**: Double-check the API provider's pricing details to ensure the `cost` parameter is set correctly.

## Acknowledgements

We would like to thank the developers of Gurobi, the contributors of the NumPy library, and the creators of the SciQ dataset for their invaluable tools and datasets that made this project possible.
