

import json

with open("test_dials_orig.json", "r") as f:
    dialogs = json.load(f)


with open("system_acts.json", "r") as f:
    system_acts = json.load(f)


for key, dialog in dialogs.items():

    easy_key = key.split(".")[0]
    if easy_key not in system_acts:
        print(key, "not existed in system acts")
        pass
    acts = system_acts[easy_key]
    num_turns = len(list(acts.keys()))
    simple_acts = []
    for i in range(1, num_turns+1):
        act = acts[str(i)]
        if isinstance(act, str):
            act = ["Null"]
        else:
            act = [a.lower() for a in list(act.keys())]
            act = sorted(act)
        simple_acts.append(act)


    dialog["dialog_acts"] = simple_acts



with open("test_dials.json", "w") as f:
    json.dump(dialogs, f, ensure_ascii=False)
