
## DSSR

This is the code and data for the paper "Decoupling Strategy and Surface Realization for Task-oriented Dialogues".

### Requirements
- Python 3.6
- PyTorch 1.4.0

Other required modules are listed in requirements.txt, you could set up a conda environment for the experiment by:  
```bash
conda create -n dssr python=3.6
conda activate dssr
pip install -r requirements.txt 
```

### Folder
- configs: the hyperparameters for DSSR SL and RL training.
- data: all the needed training/validation/testing data for MultiWOZ 2.0. 
      (due to the filesize limitation, please download MultiWOZ 2.1 from the official repo: https://github.com/budzianowski/multiwoz and run ```python create_delex_data.py``` to pre-process it).
- latent_dialog: source code for DSSR model.
- outputs: we provide our checkpoints here.
- reinforce.py: code for RL training and evaluation.
- supervised.py: code for SL training and evaluation.

### Data Preparation
The input data files are zipped put under directory ./data, it should be unzipped:
```
unzip data/act.zip -d data
unzip data/multiwoz_2.0.zip -d data
```

### Reproduce the results
We release the trained DSSR SL model and RL model checkpoints under the directory ./outputs. 
Due to the maximum filesize requirement of 100MB, we first release our model for MultiWOZ2.0. 
You can unzip the files inside to get the SL and RL folders:
```
unzip outputs/sl_woz2.0.zip -d outputs
unzip outputs/rl_woz2.0.zip -d outputs
```
To run evaluation on SL/RL:
```
python -u supervised.py --config_name sl_woz2.0 --forward_only
python -u reinforce.py --config_name rl_woz2.0 --forward_only
```

### Train DSSR model
The training process contains two stage: Supervised Training and Reinforcement Learning.

SL training for MultiWOZ2.0 / 2.1:
```
python -u supervised.py --config_name sl_woz2.0
python -u supervised.py --config_name sl_woz2.1
```

RL training for MultiWOZ2.0 / 2.1:
```
python -u reinforce.py --config_name rl_woz2.0
python -u reinforce.py --config_name rl_woz2.1
```







