import os 


# Dataset ID

DATASET_ID = {
    ## Categorical classification datasets
    'EYE_MOVEMENTS': 44157, # 7608samples and 23features
    # 'KDD_UPSELLING': 44158, # 5032samples and 45features
    'COMPASS': 44162, # 16644samples and 17features
    ## Numerical classification datasets
    'POL': 44122, # 10082samples and 26features 
}

UNL_FEATURE_NUM = {
    'EYE_MOVEMENTS': 15,
    # 'KDD_UPSELLING': 30,
    'COMPASS': 8,
    'POL': 20
}


NUMERICAL_COLS = {
    'EYE_MOVEMENTS': ['lineNo', 'assgNo', 'prevFixDur',
       'firstfixDur', 'firstPassFixDur', 'nextFixDur', 'firstSaccLen',
       'lastSaccLen', 'prevFixPos', 'landingPos', 'leavingPos', 'totalFixDur',
       'meanFixDur', 'regressLen', 'regressDur',
       'pupilDiamMax', 'pupilDiamLag', 'timePrtctg', 'titleNo', 'wordNo'],
    
    'COMPASS': ['age', 'juv_fel_count', 'juv_misd_count',
       'juv_other_count', 'priors_count', 'days_b_screening_arrest',
       'c_days_from_compas', 'end'],
    
    'POL': ['f5', 'f6', 'f7', 'f8', 'f9', 'f13', 'f14', 'f15', 'f16', 'f17', 'f18',
       'f19', 'f20', 'f21', 'f22', 'f23', 'f24', 'f25', 'f26', 'f27', 'f28',
       'f29', 'f30', 'f31', 'f32', 'f33'],
    
    'KDD_UPSELLING': ['Var6', 'Var13', 'Var21', 'Var22', 'Var24', 'Var25', 'Var28', 'Var35',
       'Var38', 'Var57', 'Var65', 'Var73', 'Var74', 'Var76', 'Var78', 'Var81',
       'Var83', 'Var85', 'Var109', 'Var112', 'Var113', 'Var119', 'Var123',
       'Var125', 'Var126', 'Var132', 'Var133', 'Var134', 'Var140', 'Var144',
       'Var149', 'Var153', 'Var160', 'Var163']
    
}


NOMINIAL_COLS = {
    'EYE_MOVEMENTS': ['P1stFixation', 'P2stFixation', 'nextWordRegress'],
    
    'COMPASS': ['sex', 'age_cat', 'race', 'c_charge_degree', 'decile_score.1', 'score_text',
       'v_type_of_assessment', 'v_decile_score', 'v_score_text'],
    
    'POL': [],
    
    'KDD_UPSELLING': ['Var196', 'Var203', 'Var205',
       'Var207', 'Var208', 'Var210', 'Var211', 'Var218', 'Var221', 'Var223',
       'Var227']
}



MODEL_SAVE_FOLDER = 'model'
ACC_SAVE_FOLDER = 'results/acc'
TRAIN_LOSS_FOLDER = 'results/train_loss'
Y_PRED_FOLDER = 'results/y_pred'
RUNNING_TIME_FOLDER = 'results/running_time'

def get_ori_model_save_path(dataset_name: str, ori_training_epochs: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_epochs{}_ori_model.pth'.format(dataset_name, ori_training_epochs))

def get_ori_model_acc_save_path(dataset_name: str, ori_training_epochs: int):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, '{}_epochs{}_ori_model_acc.txt'.format(dataset_name, ori_training_epochs))

def get_ori_model_y_pred_save_path(dataset_name: str, ori_training_epochs: int):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, '{}_epochs{}_ori_model_y_pred.txt'.format(dataset_name, ori_training_epochs))

def get_ori_model_train_loss_save_path(dataset_name: str, ori_training_epochs: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, '{}_epochs{}_ori_model_train_loss.txt'.format(dataset_name, ori_training_epochs))

def get_ori_model_running_time_save_path(dataset_name: str, ori_training_epochs: int):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, '{}_epochs{}_ori_model_running_time.txt'.format(dataset_name, ori_training_epochs))


def get_RT_model_save_path(dataset_name: str, RT_training_epochs: int, RT_train_times_idx: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_epochs{}_traintimesidx{}_RT_model.pth'.format(dataset_name, RT_training_epochs, RT_train_times_idx))

def get_RT_model_acc_save_path(dataset_name: str, RT_training_epochs: int):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, '{}_epochs{}_RT_model_acc.txt'.format(dataset_name, RT_training_epochs))

def get_RT_model_y_pred_save_path(dataset_name: str, RT_training_epochs: int, RT_train_times_idx: int):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, '{}_epochs{}_traintimesidx{}_RT_model_y_pred.txt'.format(dataset_name, RT_training_epochs, RT_train_times_idx))

def get_RT_model_train_loss_save_path(dataset_name: str, RT_training_epochs: int, RT_train_times_idx: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, '{}_epochs{}_traintimesidx{}_RT_model_train_loss.txt'.format(dataset_name, RT_training_epochs, RT_train_times_idx))

def get_RT_model_running_time_save_path(dataset_name: str, RT_training_epochs: int):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, '{}_epochs{}_RT_model_running_time.txt'.format(dataset_name, RT_training_epochs))



def get_ori_BL3RepDetExtractormodel_save_path(dataset_name: str, ori_BL3_training_epochs: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_epochs{}_ori_BL3RepDetExtractor_model.pth'.format(dataset_name, ori_BL3_training_epochs))

def get_ori_BL3Classifier_model_save_path(dataset_name: str, ori_BL3_training_epochs: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_epochs{}_ori_BL3Classifier_model.pth'.format(dataset_name, ori_BL3_training_epochs))
def get_ori_BL3_model_train_loss_save_path(dataset_name: str, ori_BL3_training_epochs: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, '{}_epochs{}_ori_BL3_model_train_loss.txt'.format(dataset_name, ori_BL3_training_epochs))
    


def get_BL1_model_save_path(dataset_name: str, ori_training_epochs: int, BL1_unlearning_epochs: int, unlearn_times_idx: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_oriep{}_ulep{}_ultimesidx{}_BL1.pth'.format(dataset_name, ori_training_epochs, BL1_unlearning_epochs, unlearn_times_idx))

def get_BL1_model_acc_save_path(dataset_name: str, ori_training_epochs: int, BL1_unlearning_epochs: int):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, '{}_oriep{}_ulep{}_BL1_acc.txt'.format(dataset_name, ori_training_epochs, BL1_unlearning_epochs))

def get_BL1_model_y_pred_save_path(dataset_name: str, ori_training_epochs: int, BL1_unlearning_epochs: int, unlearn_times_idx: int):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, '{}_oriep{}_ulep{}_ultimesidx{}_BL1_y_pred.txt'.format(dataset_name, ori_training_epochs, BL1_unlearning_epochs, unlearn_times_idx))

def get_BL1_model_train_loss_save_path(dataset_name: str, ori_training_epochs: int, BL1_unlearning_epochs: int, unlearn_times_idx: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, '{}_oriep{}_ulep{}_ultimesidx{}_BL1_train_loss.txt'.format(dataset_name, ori_training_epochs, BL1_unlearning_epochs, unlearn_times_idx))

def get_BL1_model_running_time_save_path(dataset_name: str, ori_training_epochs: int, BL1_unlearning_epochs: int):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, '{}_oriep{}_ulep{}_BL1_running_time.txt'.format(dataset_name, ori_training_epochs, BL1_unlearning_epochs))


def get_BL2_model_save_path(dataset_name: str, ori_training_epochs: int, BL2_unlearning_epochs: int, unlearn_times_idx: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_oriep{}_ulep{}_ultimesidx{}_BL2.pth'.format(dataset_name, ori_training_epochs, BL2_unlearning_epochs, unlearn_times_idx))

def get_BL2_model_acc_save_path(dataset_name: str, ori_training_epochs: int, BL2_unlearning_epochs: int):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, '{}_oriep{}_ulep{}_BL2_acc.txt'.format(dataset_name, ori_training_epochs, BL2_unlearning_epochs))

def get_BL2_model_y_pred_save_path(dataset_name: str, ori_training_epochs: int, BL2_unlearning_epochs: int, unlearn_times_idx: int):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, '{}_oriep{}_ulep{}_ultimesidx{}_BL2_y_pred.txt'.format(dataset_name, ori_training_epochs, BL2_unlearning_epochs, unlearn_times_idx))

def get_BL2_model_train_loss_save_path(dataset_name: str, ori_training_epochs: int, BL2_unlearning_epochs: int, unlearn_times_idx: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, '{}_oriep{}_ulep{}_ultimesidx{}_BL2_train_loss.txt'.format(dataset_name, ori_training_epochs, BL2_unlearning_epochs, unlearn_times_idx))

def get_BL2_model_running_time_save_path(dataset_name: str, ori_training_epochs: int, BL2_unlearning_epochs: int):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, '{}_oriep{}_ulep{}_BL2_running_time.txt'.format(dataset_name, ori_training_epochs, BL2_unlearning_epochs))



def get_BL3DecoderMIhx_model_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_oriep{}_MIhxep{}_BL3DecoderMIhx_model.pth'.format(dataset_name, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs))

def get_BL3MIhy_model_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3MIhy_training_epochs: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_oriep{}_MIhyep{}_BL3MIhy_model.pth'.format(dataset_name, ori_BL3_training_epochs, BL3MIhy_training_epochs))

def get_BL3MIhz_model_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3MIhz_training_epochs: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_oriep{}_MIhzep{}_BL3MIhz_model.pth'.format(dataset_name, ori_BL3_training_epochs, BL3MIhz_training_epochs))

def get_BL3_prep_running_time_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, '{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_BL3_prep_running_time.txt'.format(dataset_name, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs))



def get_BL3RepDetExtractor_model_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float, unlearn_times_idx: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_ultimesidx{}_BL3RepDetExtractor_model.pth'\
        .format(dataset_name, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3, unlearn_times_idx))
    
def get_BL3Classifier_model_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float, unlearn_times_idx: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_ultimesidx{}_BL3Classifier_model.pth'\
        .format(dataset_name, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3, unlearn_times_idx))
    
def get_BL3_model_acc_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, '{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_BL3_acc.txt'\
        .format(dataset_name, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3)) 

def get_BL3_model_y_pred_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float, unlearn_times_idx: int):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, '{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_ultimesidx{}_BL3_y_pred.txt'\
        .format(dataset_name, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3, unlearn_times_idx)) 

def get_BL3_model_train_task_loss_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float, unlearn_times_idx: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, '{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_ultimesidx{}_BL3_train_task_loss.txt'\
        .format(dataset_name, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3, unlearn_times_idx)) 

def get_BL3_model_train_MI_loss_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float, unlearn_times_idx: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, '{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_ultimesidx{}_BL3_train_MI_loss.txt'\
        .format(dataset_name, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3, unlearn_times_idx)) 


def get_BL3_model_running_time_save_path(dataset_name: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, '{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_BL3_runnnig_time.txt'\
        .format(dataset_name, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3))
    
    
def get_our_model_save_path(dataset_name: str, ori_training_epochs: int, unlearning_epochs: int, unlearn_times_idx: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, '{}_oriep{}_ulep{}_ultimesidx{}_our_model.pth'.format(dataset_name, ori_training_epochs, unlearning_epochs, unlearn_times_idx))

def get_our_model_acc_save_path(dataset_name: str, ori_training_epochs: int, unlearning_epochs: int):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, '{}_oriep{}_ulep{}_our_model_acc.txt'.format(dataset_name, ori_training_epochs, unlearning_epochs))

def get_our_model_y_pred_save_path(dataset_name: str, ori_training_epochs: int, unlearning_epochs: int, unlearn_times_idx: int):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, '{}_oriep{}_ulep{}_ultimesidx{}_our_model_y_pred.txt'.format(dataset_name, ori_training_epochs, unlearning_epochs, unlearn_times_idx)) 

def get_our_model_train_loss_save_path(dataset_name: str, ori_training_epochs: int, unlearning_epochs: int, unlearn_times_idx: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, '{}_oriep{}_ulep{}_ultimesidx{}_our_model_train_loss.txt'.format(dataset_name, ori_training_epochs, unlearning_epochs, unlearn_times_idx))

def get_our_model_running_time_save_path(dataset_name: str, ori_training_epochs: int, unlearning_epochs: int):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, '{}_oriep{}_ulep{}_our_model_running_time.txt'.format(dataset_name, ori_training_epochs, unlearning_epochs)) 