import os 



MODEL_SAVE_FOLDER = 'model'
ACC_SAVE_FOLDER = 'results/acc'
TRAIN_LOSS_FOLDER = 'results/train_loss'
Y_PRED_FOLDER = 'results/y_pred'
RUNNING_TIME_FOLDER = 'results/running_time'

def get_ori_model_save_path(ori_training_epochs: int, label: str):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, 'ori_label{}_epochs{}.pth'.format(ori_training_epochs, label))

def get_ori_model_acc_save_path(ori_training_epochs: int, label: str):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, 'ori_label{}_epochs{}_acc.txt'.format(ori_training_epochs, label))

def get_ori_model_y_pred_save_path(ori_training_epochs: int, label: str):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, 'ori_label{}_epochs{}_y_pred.txt'.format(ori_training_epochs, label))

def get_ori_model_train_loss_save_path(ori_training_epochs: int, label: str):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, 'ori_label{}_epochs{}_train_loss.txt'.format(ori_training_epochs, label))

def get_ori_model_running_time_save_path(ori_training_epochs: int, label: str):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, 'ori_label{}_epochs{}_running_time.txt'.format(ori_training_epochs, label))


def get_RT_model_save_path(RT_training_epochs: int, RT_train_times_idx: int, where_to_unl: str, label: str):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, 'RT_label{}_epochs{}_traintimesidx{}_wheretounl{}.pth'.format(label, RT_training_epochs, RT_train_times_idx, where_to_unl))

def get_RT_model_acc_save_path(RT_training_epochs: int, where_to_unl: str, label: str):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, 'RT_label{}_epochs{}_wheretounl{}_acc.txt'.format(label, RT_training_epochs, where_to_unl))

def get_RT_model_y_pred_save_path(RT_training_epochs: int, RT_train_times_idx: int, where_to_unl: str, label: str):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, 'RT_label{}_epochs{}_traintimesidx{}_wheretounl{}_y_pred.txt'.format(label, RT_training_epochs, RT_train_times_idx, where_to_unl))

def get_RT_model_train_loss_save_path(RT_training_epochs: int, RT_train_times_idx: int, where_to_unl: str, label: str):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, 'RT_label{}_epochs{}_traintimesidx{}_wheretounl{}_train_loss.txt'.format(label, RT_training_epochs, RT_train_times_idx, where_to_unl))

def get_RT_model_running_time_save_path(RT_training_epochs: int, where_to_unl: str, label: str):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, 'RT_label{}_epochs{}_wheretounl{}_running_time.txt'.format(label, RT_training_epochs, where_to_unl))





def get_BL2_model_save_path(ori_training_epochs: int, BL2_unlearning_epochs: int, unlearn_times_idx: int, where_to_unl: str, label: str):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, 'BL2_label{}_oriep{}_ulep{}_ultimesidx{}_wheretounl{}.pth'.format(label, ori_training_epochs, BL2_unlearning_epochs, unlearn_times_idx, where_to_unl))

def get_BL2_model_acc_save_path(ori_training_epochs: int, BL2_unlearning_epochs: int, where_to_unl: str, label: str):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, 'BL2_label{}_oriep{}_ulep{}_wheretounl{}_acc.txt'.format(label, ori_training_epochs, BL2_unlearning_epochs, where_to_unl))

def get_BL2_model_y_pred_save_path(ori_training_epochs: int, BL2_unlearning_epochs: int, unlearn_times_idx: int, where_to_unl: str, label: str):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, 'BL2_label{}_oriep{}_ulep{}_ultimesidx{}_wheretounl{}_y_pred.txt'.format(label, ori_training_epochs, BL2_unlearning_epochs, unlearn_times_idx, where_to_unl))

def get_BL2_model_train_loss_save_path(ori_training_epochs: int, BL2_unlearning_epochs: int, unlearn_times_idx: int, where_to_unl: str, label: str):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, 'BL2_label{}_oriep{}_ulep{}_ultimesidx{}_wheretounl{}_train_loss.txt'.format(label, ori_training_epochs, BL2_unlearning_epochs, unlearn_times_idx, where_to_unl))

def get_BL2_model_running_time_save_path(ori_training_epochs: int, BL2_unlearning_epochs: int, where_to_unl: str, label: str):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, 'BL2_label{}_oriep{}_ulep{}_wheretounl{}_running_time.txt'.format(label, ori_training_epochs, BL2_unlearning_epochs, where_to_unl))


def get_BL3DecoderMIhx_model_save_path(ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, label: str):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, 'label{}_oriep{}_MIhxep{}_BL3DecoderMIhx_model.pth'.format(label, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs))

def get_BL3MIhy_model_save_path(ori_BL3_training_epochs: int, BL3MIhy_training_epochs: int, label: str):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, 'label{}_oriep{}_MIhyep{}_BL3MIhy_model.pth'.format(label, ori_BL3_training_epochs, BL3MIhy_training_epochs))

def get_BL3MIhz_model_save_path(ori_BL3_training_epochs: int, BL3MIhz_training_epochs: int, label: str):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, 'label{}_oriep{}_MIhzep{}_BL3MIhz_model.pth'.format(label, ori_BL3_training_epochs, BL3MIhz_training_epochs))

def get_BL3_prep_running_time_save_path(ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, label: str):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, 'label{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_BL3_prep_running_time.txt'.format(label, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs))


def get_BL3Classifier_model_save_path(label: str, where_to_unl: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float, unlearn_times_idx: int):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, 'label{}_wheretounl{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_ultimesidx{}_BL3Classifier_model.pth'\
        .format(label, where_to_unl, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3, unlearn_times_idx))
    
def get_BL3_model_acc_save_path(label: str, where_to_unl: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, 'label{}_wheretounl{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_BL3_acc.txt'\
        .format(label, where_to_unl, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3)) 

def get_BL3_model_y_pred_save_path(label: str, where_to_unl: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float, unlearn_times_idx: int):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, 'label{}_wheretounl{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_ultimesidx{}_BL3_y_pred.txt'\
        .format(label, where_to_unl, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3, unlearn_times_idx)) 

def get_BL3_model_train_task_loss_save_path(label: str, where_to_unl: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float, unlearn_times_idx: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, 'label{}_wheretounl{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_ultimesidx{}_BL3_train_task_loss.txt'\
        .format(label, where_to_unl, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3, unlearn_times_idx)) 

def get_BL3_model_train_MI_loss_save_path(label: str, where_to_unl: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float, unlearn_times_idx: int):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, 'label{}_wheretounl{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_ultimesidx{}_BL3_train_MI_loss.txt'\
        .format(label, where_to_unl, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3, unlearn_times_idx)) 


def get_BL3_model_running_time_save_path(label: str, where_to_unl: str, ori_BL3_training_epochs: int, BL3DecoderMIhx_training_epochs: int, BL3MIhy_training_epochs: int, BL3MIhz_training_epochs: int, BL3_unlearning_epochs: int, BL3_lamda1: float, BL3_lamda2: float, BL3_lamda3: float):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, 'label{}_wheretounl{}_oriep{}_MIhxep{}_MIhyep{}_MIhzep{}_ulep{}_l1{}_l2{}_l3{}_BL3_runnnig_time.txt'\
        .format(label, where_to_unl, ori_BL3_training_epochs, BL3DecoderMIhx_training_epochs, BL3MIhy_training_epochs, BL3MIhz_training_epochs, BL3_unlearning_epochs, BL3_lamda1, BL3_lamda2, BL3_lamda3))



    
def get_our_model_save_path(ori_training_epochs: int, unlearning_epochs: int, unlearn_times_idx: int, where_to_unl: str, label: str):
    os.makedirs(MODEL_SAVE_FOLDER, exist_ok=True)
    return os.path.join(MODEL_SAVE_FOLDER, 'ours_label{}_oriep{}_ulep{}_ultimesidx{}_wheretounl{}.pth'.format(label, ori_training_epochs, unlearning_epochs, unlearn_times_idx, where_to_unl))

def get_our_model_acc_save_path(ori_training_epochs: int, unlearning_epochs: int, where_to_unl: str, label: str):
    os.makedirs(ACC_SAVE_FOLDER, exist_ok=True)
    return os.path.join(ACC_SAVE_FOLDER, 'ours_label{}_oriep{}_ulep{}_wheretounl{}_acc.txt'.format(label, ori_training_epochs, unlearning_epochs, where_to_unl))

def get_our_model_y_pred_save_path(ori_training_epochs: int, unlearning_epochs: int, unlearn_times_idx: int, where_to_unl: str, label: str):
    os.makedirs(Y_PRED_FOLDER, exist_ok=True)
    return os.path.join(Y_PRED_FOLDER, 'ours_label{}_oriep{}_ulep{}_ultimesidx{}_wheretounl{}_y_pred.txt'.format(label, ori_training_epochs, unlearning_epochs, unlearn_times_idx, where_to_unl)) 

def get_our_model_train_loss_save_path(ori_training_epochs: int, unlearning_epochs: int, unlearn_times_idx: int, where_to_unl: str, label: str):
    os.makedirs(TRAIN_LOSS_FOLDER, exist_ok=True)
    return os.path.join(TRAIN_LOSS_FOLDER, 'ours_label{}_oriep{}_ulep{}_ultimesidx{}_wheretounl{}_train_loss.txt'.format(label, ori_training_epochs, unlearning_epochs, unlearn_times_idx, where_to_unl))

def get_our_model_running_time_save_path(ori_training_epochs: int, unlearning_epochs: int, where_to_unl: str, label: str):
    os.makedirs(RUNNING_TIME_FOLDER, exist_ok=True)
    return os.path.join(RUNNING_TIME_FOLDER, 'ours_label{}_oriep{}_ulep{}_wheretounl{}_running_time.txt'.format(label, ori_training_epochs, unlearning_epochs, where_to_unl)) 