import os
import numpy as np

def check_easy_npy_files():
    # 定义目录路径
    data_dir = "/home/wxy/EnGNODE/EnGNODE/con_formation/easy"
    # 遍历目录下所有文件
    for filename in os.listdir(data_dir):
        file_path = os.path.join(data_dir, filename)
        if filename.endswith(".npy"):  # 仅处理.npy文件
            try:
                data = np.load(file_path)
                print(f"文件 {filename} 读取成功，数据形状: {data.shape}")
                print(f"数据均值: {np.mean(data)}, 数据标准差: {np.std(data)}")
                # 可根据需求添加更多检查逻辑，例如检查数据是否有NaN/Inf
                if np.isnan(data).any() or np.isinf(data).any():
                    print(f"文件 {filename} 中存在 NaN 或 Inf 值")
            except Exception as e:
                print(f"读取文件 {filename} 时出错: {e}")

if __name__ == "__main__":
    check_easy_npy_files()