# -*- coding: utf-8 -*-
"""
Plot_realworlddataset
"""

import numpy as np
import matplotlib.pyplot as plt



acc_ts = np.load("acc_ts_ML5000.npy")
acc_peps = np.load("acc_peps_ML5000.npy")
acc_ttts = np.load("acc_ttts_ML5000.npy")


# Parameters
T = 5000
num_runs = 50
sigma2 = 1 ** 2
gamma2 = 1 ** 2
tau = 7.5


acc_ts, acc_peps, acc_ttts = map(np.array, [acc_ts, acc_peps, acc_ttts])

# Compute mean and stderr
mean_ts = acc_ts.mean(axis=0)
err_ts = acc_ts.std(axis=0) / np.sqrt(num_runs)
mean_peps = acc_peps.mean(axis=0)
err_peps = acc_peps.std(axis=0) / np.sqrt(num_runs)
mean_ttts = acc_ttts.mean(axis=0)
err_ttts = acc_ttts.std(axis=0) / np.sqrt(num_runs)

# Save results
np.save("acc_ts_ML5000.npy", acc_ts)
np.save("acc_peps_ML5000.npy", acc_peps)
np.save("acc_ttts_ML5000.npy", acc_ttts)

# Plot
plt.figure(figsize=(10, 6))
plt.plot(mean_ts, label='LinTS (Feasible)', color='green')
plt.fill_between(range(T), mean_ts - err_ts, mean_ts + err_ts, color='green', alpha=0.2)
plt.plot(mean_peps, label='BLFAIPS', color='purple')
plt.fill_between(range(T), mean_peps - err_peps, mean_peps + err_peps, color='purple', alpha=0.2)
plt.plot(mean_ttts, label='LinTTTS with beta=0.5', color='orange')
plt.fill_between(range(T), mean_ttts - err_ttts, mean_ttts + err_ttts, color='orange', alpha=0.2)
plt.xlabel("Time Step")
plt.ylabel("Accuracy")

plt.xlim((0,5000))
plt.ylim((0,0.8))
#plt.ylim((0,7))
plt.xticks([0,500,1000,1500,2000,2500,3000,3500,4000,4500,5000], fontsize=12)
plt.yticks([0.0,0.2,0.4,0.6,0.8], fontsize=12)

#plt.title("MovieLens Accuracy: BLFAIPS vs TTTS vs Linear TS")
plt.grid(True)
plt.legend(loc='lower right',fontsize=12)
plt.tight_layout()
plt.savefig('real.png', format='png', dpi=300)
plt.savefig("real.pdf", format="pdf", bbox_inches='tight')

plt.show()
