import xgboost as xgb

class LilaveModelXGB:
    def __init__(self, aggregate, model=None):
        assert aggregate in {'min', 'max', 'avg'}
        self.aggregate = {
            'min': min,
            'max': max,
            'avg': lambda x: sum(x) / len(x),
        }[aggregate]
        self.model = model

    def load(self, xgb_model_path):
        self.model = xgb.Booster()
        self.model.load_model(xgb_model_path)
        print(f'Model from {xgb_model_path} loaded.')

    def __call__(self, hidden_states):
        assert self.model
        hidden_states = xgb.DMatrix(hidden_states)
        scores = self.model.predict(hidden_states)
        score = self.aggregate(scores)
        return float(score)
