#! /usr/bin/env Rscript
library(dplyr)
library(xgboost)

csv<-commandArgs(trailingOnly=T)[[1]]
print("Reading data...")
df<-read.csv(csv, header=F)
colnames(df)[1]<-'example'
colnames(df)[2]<-'correct'
colnames(df)[3]<-'layer'
colnames(df)[4]<-'token'

label<-df$correct
df$correct<-NULL
df$example<-NULL

print("Fitting model...")
model <- xgboost(data=as.matrix(df), label=label,
         max.depth=10,
         eta=0.1,
         nthread=16,
         nrounds=30,
         objective="binary:logistic")
print(model)
xgb.importance(colnames(df), model=model)
path<-paste(sub('csv$', '', csv), 'xgb', sep='')
xgb.save(model, path)
print(path)
