/*
 * Decompiled with CFR 0.152.
 */
package x.y.z;

import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.eval.CompletionResult;
import de.unima.ki.anyburl.eval.ResultSet;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;

public class ReflexivityFix {
    public static void main(String[] args) throws FileNotFoundException {
        String[] models;
        String trainTS = "data/CODEX/M/train.txt";
        String[] stringArray = models = new String[]{"complex", "conve", "hitter", "rescal", "transe", "tucker"};
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            String model = stringArray[n2];
            System.out.println("RF on " + model);
            String inputRS = "exp/understanding/codex-m/" + model + "-100-test";
            String outputRS = "exp/understanding/codex-m/" + model + "-100-test-RF";
            ReflexivityFix.writeFilteredResultSet(trainTS, inputRS, outputRS);
            ++n2;
        }
    }

    private static void writeFilteredResultSet(String trainTS, String inputRS, String outputRS) throws FileNotFoundException {
        TripleSet ts = new TripleSet(trainTS);
        HashSet<String> neverReflexivRelations = new HashSet<String>();
        ResultSet rs = new ResultSet("anonym", inputRS, true, 100);
        for (String relation : ts.getRelations()) {
            ArrayList triplesR = ts.getTriplesByRelation(relation);
            boolean neverReflexiv = true;
            for (Triple t : triplesR) {
                if (!t.getHead().equals(t.getTail())) continue;
                neverReflexiv = false;
            }
            if (!neverReflexiv) continue;
            neverReflexivRelations.add(relation);
        }
        System.out.println("found " + neverReflexivRelations.size() + " relations that are never reflexive ");
        ResultSet rsF = new ResultSet();
        for (String t : rs.getTriples()) {
            CompletionResult cr = rs.getCompletionResult(t);
            String[] token = t.split(" ");
            String head = token[0];
            String relation = token[1];
            String tail = token[2];
            if (!neverReflexivRelations.contains(relation)) {
                rsF.results.put(t, cr);
                continue;
            }
            CompletionResult crF = new CompletionResult(t);
            ArrayList<Double> headConfidences = new ArrayList<Double>();
            ArrayList<Double> tailConfidences = new ArrayList<Double>();
            ArrayList<String> heads = new ArrayList<String>();
            ArrayList<String> tails = new ArrayList<String>();
            int i = 0;
            while (i < cr.getHeads().size()) {
                if (!((String)cr.getHeads().get(i)).equals(tail)) {
                    heads.add((String)cr.getHeads().get(i));
                    headConfidences.add((Double)cr.getHeadConfidences().get(i));
                }
                ++i;
            }
            i = 0;
            while (i < cr.getTails().size()) {
                if (!((String)cr.getTails().get(i)).equals(head)) {
                    tails.add((String)cr.getTails().get(i));
                    tailConfidences.add((Double)cr.getTailConfidences().get(i));
                }
                ++i;
            }
            crF.setHeads(heads);
            crF.setHeadConfidences(headConfidences);
            crF.setTails(tails);
            crF.setTailConfidences(tailConfidences);
            rsF.results.put(t, crF);
        }
        System.out.println("wrote result set to " + outputRS);
        rsF.write(outputRS);
    }
}

