model_name=LPI-LLM
train_epochs=100
learning_rate=0.01
llm_layers=32

master_port=26197
num_process=2
batch_size=5
d_model=32
d_ff=128

comment='Train'

accelerate launch --multi_gpu --mixed_precision bf16 --num_processes $num_process --main_process_port $master_port train.py \
  --task_name long_term_forecast \
  --is_training 1 \
  --root_path ./dataset/ \
  --data_path set_cleaned_sampled.pickle \
  --model_id lpi_llm \
  --model $model_name \
  --data LPI4AI \
  --features M \
  --seq_len 400 \
  --label_len 48 \
  --pred_len 400 \
  --patch_len 16 \
  --stride 8 \
  --factor 3 \
  --enc_in 7 \
  --dec_in 7 \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 \
  --d_model $d_model \
  --d_ff $d_ff \
  --batch_size $batch_size \
  --learning_rate $learning_rate \
  --llm_layers $llm_layers \
  --train_epochs $train_epochs \
  --model_comment $comment 