# Code Structure
Below are details on the layout of the code. The environment can be set up using conda with the environment.yml file.

## misc/
Utilities for loading models, datasets, and neighborhood definitions.

## p3/
This directory contains PoisonM implementations of generating the standard dataset, and datasets containing poison neighbors and non-neighbors for each neighborhood definition (one file per definition). 

## gdm/
This directory contains implementations of generating poison neighbors and non-neighbors using the baseline Liu et al. techniques (token dropouts, casing flips, chunking) for each neighborhood definition.

## mia_tests_library.py
Utilities for running membership tests, sourced from Maini et al. As suggested by them, clone the github repo from https://github.com/GEM-benchmark/NL-Augmenter into this directory to get code for the perturb membership tests.

## results_auc.py
Code for evaluating the membership tests against a model (standard or poisoned).

## finetune.py
Code for finetuning a model on a dataset (standard or poisoned).

# Running code
Examples of using code to (1) generate datasets (standard or poisoned), (b) finetuning on the datasets, and then (c) running the tests on the trained models, are provided in run.sh.




