export HF_HOME=""
export HF_TOKEN=""
export CUDA_VISIBLE_DEVICES=0,1

# ############################ STANDARD #############################
# 1. Generate the dataset
python -m p3.standard \
    --dataset_name ai4privacy \
    --output_dataset_path OUTPUT_DATASET_PATH

# 2. Fine-tune the model
python finetune.py \
    --model_name "EleutherAI/pythia-6.9b" \
    --dataset_path OUTPUT_DATASET_PATH \
    --save_path OUTPUT_MODEL_PATH \

# ###################################################################

############################ EXACT MATCH #####################
# 1. Generate the dataset
python -m p3.exact_match \
    --dataset_name ai4privacy \
    --attack_model_name "EleutherAI/pythia-6.9b" \
    --output_dataset_path OUTPUT_DATASET_PATH

# 2. Fine-tune the model
python finetune.py \
    --model_name "EleutherAI/pythia-6.9b" \
    --dataset_path OUTPUT_DATASET_PATH \
    --save_path OUTPUT_MODEL_PATH

# 3. Run the MIA tests
python run_mia_tests.py \
    --model_name OUTPUT_MODEL_PATH \
    --dataset_name ai4privacy \
    --definition "exact_match" \
    --output_result_report_path OUTPUT_RESULT_REPORT_PATH
##################################################################

############################ NGRAM ############################
# 1. Generate the dataset
python -m p3.ngram \
    --k 7 \
    --attack_model_name "EleutherAI/pythia-6.9b" \
    --dataset_name ai4privacy \
    --output_dataset_path OUTPUT_DATASET_PATH

# 2. Fine-tune the model
python finetune.py \
    --model_name "EleutherAI/pythia-6.9b" \
    --dataset_path OUTPUT_DATASET_PATH \
    --save_path OUTPUT_MODEL_PATH

# 3. Run the MIA tests
python run_mia_tests.py \
    --model_name OUTPUT_MODEL_PATH \
    --dataset_name ai4privacy \
    --definition "ngram" \
    --definition_hyperparameter 7 \
    --output_result_report_path OUTPUT_RESULT_REPORT_PATH
##################################################################

########################### EMBEDDING #######################
# 1. Generate the dataset
python -m p3.embedding \
    --cs 0.9 \
    --attack_model_name "EleutherAI/pythia-6.9b" \
    --dataset_name ai4privacy \
    --output_dataset_path OUTPUT_DATASET_PATH

# 2. Fine-tune the model
python finetune.py \
    --model_name "EleutherAI/pythia-6.9b" \
    --dataset_path OUTPUT_DATASET_PATH \
    --save_path OUTPUT_MODEL_PATH

# 3. Run the MIA tests
python run_mia_tests.py \
    --model_name OUTPUT_MODEL_PATH \
    --dataset_name ai4privacy \
    --definition "embedding" \
    --definition_hyperparameter 0.9 \
    --output_result_report_path OUTPUT_RESULT_REPORT_PATH
#################################################################


########################## INDEL SIMILARITY #####################
# 1. Generate the dataset
python -m p3.indel_similarity \
    --sim 0.52 \
    --attack_model_name "EleutherAI/pythia-6.9b" \
    --dataset_name ai4privacy \
    --output_dataset_path OUTPUT_DATASET_PATH

# 2. Fine-tune the model
python finetune.py \
    --model_name "EleutherAI/pythia-6.9b" \
    --dataset_path OUTPUT_DATASET_PATH \
    --save_path OUTPUT_MODEL_PATH

# 3. Run the MIA tests
python run_mia_tests.py \
    --model_name OUTPUT_MODEL_PATH \
    --dataset_name ai4privacy \
    --definition "indel_similarity" \
    --definition_hyperparameter 0.52 \
    --output_result_report_path OUTPUT_RESULT_REPORT_PATH
####################################################################