device=(0 0 1 2 3 4 5 6 7)

save_dir=bmm
if [ ! -e $save_dir ];
then
    mkdir -p $save_dir
fi

p=(100 200 300 400)
m=(10 20 30 40)
T=1000000
methods=(RW_R-1 RW_R-5 Gibbs_R-1 Gibbs_R-5 GWG_R-1 GWG_R-5 MSA_R-5 MSF_R-5 LB_R-1)

for i in ${!p[*]}; do
  for k in ${!methods[*]}; do
    echo --model bmm > ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --method ${methods[k]} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --p ${p[i]} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --T ${T} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --m ${m[i]} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --device ${device[k]} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
  done
done