mu=2.0
sigma=3.0
lamda=1.0
device=(0 0 1 2 3 4 5 6 7)

save_dir=ising
if [ ! -e $save_dir ];
then
    mkdir -p $save_dir
fi

p=(50 100 150 200)
T=1000000
methods=(RW_R-1 RW_R-10 Gibbs_R-1 Gibbs_R-5 GWG_R-1 GWG_R-10 MSA_R-10 MSF_R-10 LB_R-1)

for i in ${!p[*]}; do
  for k in ${!methods[*]}; do
    echo --model ising > ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --method ${methods[k]} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --p ${p[i]} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --T ${T} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --mu ${mu} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --sigma ${sigma} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --lamda ${lamda} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
    echo --device ${device[k]} >> ${save_dir}/p-${p[i]}_$(($k + 1)).txt
  done
done
