import numpy as np
import matplotlib.pyplot as plt


t = [5, 10, 25, 50]
gwg	= np.log(np.array([0.0159111, 0.010039,	0.00782581, 0.00729527]))
gwg_5 = np.log(np.array([0.0098244, 0.007849, 0.006784, 0.0061169]))
pafs_5 = np.log(np.array([0.0081766, 0.007512, 0.006687, 0.00603049]))

fig, ax = plt.subplots(1, 1, figsize=(8, 6))
ax.plot(t, gwg, label='GWG', color='tab:blue')
ax.plot(t, gwg_5, label='GWG-5', color='tab:orange')
ax.plot(t, pafs_5, label='PAFS-5', color='tab:green')

ax.legend(fontsize=16)
ax.set_title('Log (RMSE) of Connectivity Matrix', fontsize=16)
ax.set_xlabel('Sampling Steps', fontsize=12)
ax.tick_params(labelsize=12)
ax.grid()
plt.savefig('figs/learning_ising.pdf')
# plt.show()

