param_dims = {
    "Mug": {
        "Multilevel_Body": {
            "num_levels": [
                1
            ],
            "level_1_bottom_radius": [
                2
            ],
            "level_1_top_radius": [
                2
            ],
            "level_1_height": [
                2
            ],
            "level_2_top_radius": [
                2
            ],
            "level_2_height": [
                1
            ],
            "level_3_top_radius": [
                2
            ],
            "level_3_height": [
                1
            ],
            "level_4_top_radius": [
                2
            ],
            "level_4_height": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Prismatic_Body": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Single_Cylinder": {
            "size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Curved_Handle": {
            "radius": [
                2
            ],
            "rotation": [
                3
            ],
            "central_angle": [
                1
            ],
            "position": [
                3
            ]
        },
        "Cylindrical_Body": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Handle": {
            "horizontal_length": [
                2
            ],
            "horizontal_thickness": [
                2
            ],
            "vertical_thickness": [
                2
            ],
            "horizontal_rotation": [
                2
            ],
            "horizontal_separation": [
                1
            ],
            "mounting_offset": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Ruler": {
        "Symmetrical_body": {
            "size": [
                3
            ],
            "left_right_offset": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "body_rotation": [
                1
            ],
            "separation": [
                1
            ]
        },
        "Regular_shaft": {
            "size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Box": {
        "Cuboidal_Body": {
            "top_size": [
                2
            ],
            "bottom_size": [
                2
            ],
            "height": [
                1
            ],
            "top_bottom_offset": [
                2
            ],
            "thickness": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Fourfold_Cover": {
            "has_cover": [
                4
            ],
            "front_behind_size": [
                3
            ],
            "left_right_size": [
                3
            ],
            "rotation": [
                3
            ],
            "cover_separation": [
                2
            ],
            "cover_rotation": [
                4
            ],
            "position": [
                3
            ]
        },
        "Regular_Cover": {
            "inner_size": [
                3
            ],
            "rotation": [
                3
            ],
            "outer_size": [
                3
            ],
            "position": [
                3
            ]
        },
        "Cuboidal_Leg": {
            "front_legs_size": [
                3
            ],
            "rear_legs_size": [
                3
            ],
            "num_legs": [
                1
            ],
            "legs_separation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "StorageFurniture": {
        "Storagefurniture_body": {
            "size": [
                3
            ],
            "back_size": [
                1
            ],
            "left_right_inner_size": [
                1
            ],
            "base_size": [
                1
            ],
            "has_lid": [
                1
            ],
            "lid_size": [
                3
            ],
            "lid_offset": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "storagefurniture_layers_params": [
                92
            ],
            "additional_layers_params": [
                179
            ],
            "WHOLE_interval_between_layers": [
                12
            ],
            "WHOLE_layer_offset": [
                1
            ],
            "WHOLE_layer_sizes": [
                1
            ],
            "WHOLE_number_of_layer": [
                1
            ]
        },
        "Regular_door": {
            "number_of_door": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "doors_params": [
                96
            ]
        },
        "Regular_front_panel": {
            "number_of_frontPanel": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "frontPanel_params": [
                54
            ]
        },
        "Regular_drawer": {
            "number_of_drawer": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "drawers_params": [
                220
            ]
        },
        "Enclosed_leg": {
            "size": [
                3
            ],
            "inner_sizes": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "additional_legs_params": [
                37
            ]
        }
    },
    "Safe": {
        "Mutiple_Layer_Body": {
            "size": [
                3
            ],
            "main_clapboard_size": [
                2
            ],
            "main_clapboard_offset": [
                1
            ],
            "sub_clapboard_1_size": [
                3
            ],
            "sub_clapboard_1_offset": [
                2
            ],
            "sub_clapboard_2_size": [
                3
            ],
            "sub_clapboard_2_offset": [
                2
            ],
            "sub_clapboard_3_size": [
                3
            ],
            "sub_clapboard_3_offset": [
                2
            ],
            "sub_clapboard_4_size": [
                3
            ],
            "sub_clapboard_4_offset": [
                2
            ],
            "sub_clapboard_5_size": [
                3
            ],
            "sub_clapboard_5_offset": [
                2
            ],
            "sub_clapboard_6_size": [
                3
            ],
            "sub_clapboard_6_offset": [
                2
            ],
            "sub_clapboard_7_size": [
                3
            ],
            "sub_clapboard_7_offset": [
                2
            ],
            "sub_clapboard_8_size": [
                3
            ],
            "sub_clapboard_8_offset": [
                2
            ],
            "sub_clapboard_9_size": [
                3
            ],
            "sub_clapboard_9_offset": [
                2
            ],
            "sub_clapboard_10_size": [
                3
            ],
            "sub_clapboard_10_offset": [
                2
            ],
            "thickness": [
                5
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "num_of_sub_clapboards": [
                1
            ]
        },
        "Behind_Double_Layer_Door": {
            "rotation": [
                3
            ],
            "behind_size": [
                3
            ],
            "behind_offset": [
                2
            ],
            "position": [
                3
            ],
            "main_size": [
                3
            ]
        },
        "Front_Double_Layer_Door": {
            "rotation": [
                3
            ],
            "front_size": [
                3
            ],
            "front_offset": [
                2
            ],
            "position": [
                3
            ],
            "main_size": [
                3
            ]
        },
        "Cylindrical_Connecter": {
            "size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Handle": {
            "bottom_size": [
                3
            ],
            "bottom_seperation": [
                1
            ],
            "top_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Sunken_Door": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "sunken_size": [
                3
            ],
            "sunken_offset": [
                2
            ],
            "position": [
                3
            ]
        },
        "Cuboidal_Leg": {
            "front_legs_size": [
                3
            ],
            "rear_legs_size": [
                3
            ],
            "legs_separation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "num_legs": [
                1
            ]
        },
        "Cylindrical_Dial": {
            "bottom_size": [
                3
            ],
            "top_size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Door": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Cuboidal_Body": {
            "size": [
                3
            ],
            "thickness": [
                5
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Regular_Controller": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Round_Handle": {
            "bottom_size": [
                2
            ],
            "fork_size": [
                3
            ],
            "fork_offset": [
                1
            ],
            "fork_tilt_rotation": [
                1
            ],
            "circle_size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "num_forks": [
                1
            ]
        },
        "T_Shaped_Connecter": {
            "cylinder_size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "lateral_cuboid_size": [
                3
            ],
            "lateral_cuboid_offset": [
                1
            ]
        },
        "Claw_Handle": {
            "bottom_size": [
                2
            ],
            "fork_size": [
                3
            ],
            "fork_offset": [
                1
            ],
            "fork_tilt_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "num_forks": [
                1
            ]
        }
    },
    "Chair": {
        "Regular_seat": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Regular_leg_with_splat": {
            "front_legs_size": [
                3
            ],
            "rear_legs_size": [
                3
            ],
            "legs_separation": [
                3
            ],
            "central_rotation": [
                1
            ],
            "front_rotation": [
                2
            ],
            "rear_rotation": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "front_rear_bridging_bars_sizes": [
                2
            ],
            "left_right_bridging_bars_sizes": [
                2
            ],
            "front_rear_bridging_bars_offset": [
                2
            ],
            "left_right_bridging_bars_offset": [
                2
            ],
            "bridging_bars_existance": [
                4
            ]
        },
        "Solid_armrest": {
            "size": [
                3
            ],
            "armrest_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "armrest_rotation": [
                2
            ]
        },
        "Round_seat": {
            "size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Star_leg": {
            "vertical_sizes": [
                2
            ],
            "sub_sizes": [
                3
            ],
            "number_of_sub_legs": [
                1
            ],
            "sub_central_offset": [
                1
            ],
            "tilt_angle": [
                1
            ],
            "central_rotation": [
                1
            ],
            "horizontal_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Barstool_leg": {
            "vertical_sizes": [
                2
            ],
            "bottom_sizes": [
                2
            ],
            "horizontal_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "C_shaped_office_leg": {
            "vertical_leg_size": [
                3
            ],
            "vertical_leg_separation": [
                1
            ],
            "vertical_leg_rotation": [
                2
            ],
            "horizontal_leg_rotation": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "horizontal_z_leg_size": [
                2
            ],
            "horizontal_x_leg_size": [
                1
            ]
        },
        "Office_armrest": {
            "armrest_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "horizontal_support_sizes": [
                3
            ],
            "vertical_support_sizes": [
                3
            ],
            "supports_contact_offset": [
                1
            ],
            "vertical_support_rotation": [
                1
            ],
            "horizontal_support_rotation": [
                1
            ],
            "armrest_rotation": [
                1
            ]
        },
        "Solid_back": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "back_rotation": [
                1
            ]
        },
        "Latice_back": {
            "main_horizontal_piece_size": [
                3
            ],
            "main_vertical_piece_size": [
                3
            ],
            "main_vertical_separation": [
                1
            ],
            "sub_horizontal_piece_size": [
                2
            ],
            "sub_vertical_piece_size": [
                2
            ],
            "number_of_subs": [
                1
            ],
            "interval_between_subs": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "back_rotation": [
                1
            ],
            "sub_horizontal_offset": [
                1
            ],
            "sub_vertical_offset": [
                1
            ]
        },
        "Slat_back": {
            "main_vertical_piece_size": [
                3
            ],
            "sub_horizontal_piece_size": [
                2
            ],
            "main_vertical_separation": [
                1
            ],
            "number_of_subs": [
                1
            ],
            "interval_between_subs": [
                1
            ],
            "main_vertical_rotation": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "back_rotation": [
                1
            ],
            "sub_horizontal_offset": [
                1
            ]
        },
        "Splat_back": {
            "main_horizontal_piece_size": [
                3
            ],
            "main_vertical_piece_size": [
                3
            ],
            "sub_vertical_piece_size": [
                2
            ],
            "main_vertical_separation": [
                1
            ],
            "number_of_subs": [
                1
            ],
            "sub_offset": [
                1
            ],
            "interval_between_subs": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "back_rotation": [
                1
            ]
        },
        "Ladder_back": {
            "main_horizontal_piece_size": [
                3
            ],
            "main_vertical_piece_size": [
                3
            ],
            "sub_horizontal_piece_size": [
                2
            ],
            "main_vertical_separation": [
                1
            ],
            "number_of_subs": [
                1
            ],
            "sub_offset": [
                1
            ],
            "interval_between_subs": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "back_rotation": [
                1
            ]
        },
        "Regular_leg": {
            "front_legs_size": [
                3
            ],
            "rear_legs_size": [
                3
            ],
            "number_of_legs": [
                1
            ],
            "legs_separation": [
                3
            ],
            "central_rotation": [
                1
            ],
            "front_rotation": [
                2
            ],
            "rear_rotation": [
                2
            ],
            "symmetry_mode": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Oven": {
        "Double_Layer_Body": {
            "size": [
                3
            ],
            "clapboard_size": [
                2
            ],
            "clapboard_offset": [
                1
            ],
            "thickness": [
                5
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Curve_Handle": {
            "curve_size": [
                3
            ],
            "curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Door": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Body": {
            "size": [
                3
            ],
            "thickness": [
                5
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Handle": {
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ],
            "grip_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Controller_With_Button": {
            "bottom_size": [
                4
            ],
            "button_1_size": [
                3
            ],
            "button_1_offset": [
                2
            ],
            "button_2_size": [
                3
            ],
            "button_2_offset": [
                2
            ],
            "button_3_size": [
                3
            ],
            "button_3_offset": [
                2
            ],
            "button_4_size": [
                3
            ],
            "button_4_offset": [
                2
            ],
            "button_5_size": [
                3
            ],
            "button_5_offset": [
                2
            ],
            "button_6_size": [
                3
            ],
            "button_6_offset": [
                2
            ],
            "button_7_size": [
                3
            ],
            "button_7_offset": [
                2
            ],
            "button_8_size": [
                3
            ],
            "button_8_offset": [
                2
            ],
            "button_9_size": [
                3
            ],
            "button_9_offset": [
                2
            ],
            "button_10_size": [
                3
            ],
            "button_10_offset": [
                2
            ],
            "num_buttons": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Drawer_Like_Tray": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Top_With_Burner": {
            "bottom_size": [
                3
            ],
            "num_burners": [
                1
            ],
            "burner_1_size": [
                3
            ],
            "burner_1_offset": [
                2
            ],
            "burner_1_central_size": [
                2
            ],
            "burner_1_central_offset": [
                2
            ],
            "burner_2_size": [
                3
            ],
            "burner_2_offset": [
                2
            ],
            "burner_2_central_size": [
                2
            ],
            "burner_2_central_offset": [
                2
            ],
            "burner_3_size": [
                3
            ],
            "burner_3_offset": [
                2
            ],
            "burner_3_central_size": [
                2
            ],
            "burner_3_central_offset": [
                2
            ],
            "burner_4_size": [
                3
            ],
            "burner_4_offset": [
                2
            ],
            "burner_4_central_size": [
                2
            ],
            "burner_4_central_offset": [
                2
            ],
            "burner_5_size": [
                3
            ],
            "burner_5_offset": [
                2
            ],
            "burner_5_central_size": [
                2
            ],
            "burner_5_central_offset": [
                2
            ],
            "burner_6_size": [
                3
            ],
            "burner_6_offset": [
                2
            ],
            "burner_6_central_size": [
                2
            ],
            "burner_6_central_offset": [
                2
            ],
            "burner_1_thickness": [
                1
            ],
            "burner_2_thickness": [
                1
            ],
            "burner_3_thickness": [
                1
            ],
            "burner_4_thickness": [
                1
            ],
            "burner_5_thickness": [
                1
            ],
            "burner_6_thickness": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Multilevel_Leg": {
            "front_legs_size": [
                3
            ],
            "rear_legs_size": [
                3
            ],
            "num_legs": [
                1
            ],
            "legs_separation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Baffle": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Flat_Tray": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Sunken_Door": {
            "size": [
                3
            ],
            "sunken_size": [
                3
            ],
            "sunken_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Curve_Handle": {
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ],
            "curve_size": [
                3
            ],
            "curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "USB": {
        "Regular_Body": {
            "size": [
                3
            ],
            "has_back_part": [
                1
            ],
            "has_side_part": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Regular_Connector": {
            "size": [
                3
            ],
            "thickness": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "RoundEnded_Cap": {
            "size": [
                3
            ],
            "proximal_interval": [
                1
            ],
            "inclination": [
                1
            ],
            "has_shaft": [
                1
            ],
            "shaft_size": [
                2
            ],
            "shaft_offset": [
                1
            ],
            "cap_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "shaft_interval": [
                1
            ]
        },
        "RoundEnded_Body": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Regular_Cap": {
            "size": [
                3
            ],
            "inner_size": [
                3
            ],
            "inner_outer_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "SquareEnded_Cap": {
            "size": [
                3
            ],
            "proximal_interval": [
                1
            ],
            "inclination": [
                1
            ],
            "has_shaft": [
                1
            ],
            "shaft_size": [
                2
            ],
            "shaft_offset": [
                1
            ],
            "cap_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "shaft_interval": [
                1
            ]
        },
        "Simplied_Connector": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Switch": {
        "Round_Switch": {
            "number_of_switch": [
                1
            ],
            "size": [
                2
            ],
            "offset_1": [
                3
            ],
            "offset_2": [
                3
            ],
            "offset_3": [
                3
            ],
            "offset_4": [
                3
            ],
            "offset_Z": [
                3
            ],
            "switch_rotation": [
                4
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Standard_Base": {
            "size": [
                3
            ],
            "back_part_size": [
                3
            ],
            "back_part_offset": [
                2
            ],
            "has_back_part": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Plug": {
            "size": [
                3
            ],
            "column_of_contact": [
                1
            ],
            "row_of_contact": [
                1
            ],
            "interval": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "FlipX_Switch": {
            "size": [
                3
            ],
            "number_of_switch": [
                1
            ],
            "switch_rotation": [
                1
            ],
            "separation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "FlipY_Switch": {
            "size": [
                3
            ],
            "number_of_switch": [
                1
            ],
            "switch_rotation": [
                1
            ],
            "separation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Plug": {
            "size": [
                3
            ],
            "column_of_contact": [
                1
            ],
            "row_of_contact": [
                1
            ],
            "interval": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Lever_Switch": {
            "switch_rotation": [
                4
            ],
            "base_size": [
                2
            ],
            "main_size": [
                3
            ],
            "number_of_switch": [
                1
            ],
            "inter_offset": [
                3
            ],
            "separation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Standard_Knob": {
            "size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Frame_Base": {
            "size": [
                3
            ],
            "inner_size": [
                2
            ],
            "inner_outer_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Laptop": {
        "Regular_Base": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Regular_Screen": {
            "size": [
                3
            ],
            "offset": [
                2
            ],
            "screen_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Connector": {
            "number_of_connector": [
                1
            ],
            "size": [
                2
            ],
            "separation": [
                4
            ],
            "offset": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Connector": {
            "number_of_connector": [
                1
            ],
            "size": [
                3
            ],
            "separation": [
                4
            ],
            "offset": [
                3
            ],
            "connector_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Bottle": {
        "Multilevel_Body": {
            "num_levels": [
                1
            ],
            "level_1_size": [
                3
            ],
            "level_2_size": [
                2,
                3
            ],
            "level_3_size": [
                2,
                3
            ],
            "level_4_size": [
                2,
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Lid": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Table": {
        "Cylindrical_desktop": {
            "size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Bar_cuboid_leg": {
            "vertical_size": [
                3
            ],
            "bottom_size": [
                3
            ],
            "bottom_rotation": [
                1
            ],
            "horizontal_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "additional_legs_params": [
                37
            ]
        },
        "Regular_leg": {
            "front_legs_size": [
                3
            ],
            "rear_legs_size": [
                3
            ],
            "number_of_legs": [
                1
            ],
            "legs_separation": [
                3
            ],
            "central_rotation": [
                1
            ],
            "front_rotation": [
                2
            ],
            "rear_rotation": [
                2
            ],
            "symmetry_mode": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "additional_legs_params": [
                37
            ]
        },
        "Regular_desktop": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_sublayer": {
            "subs_size": [
                2
            ],
            "number_of_subs": [
                1
            ],
            "subs_offset": [
                1
            ],
            "interval_between_subs": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "additional_sublayers_params": [
                37
            ]
        },
        "Regular_with_splat_leg": {
            "front_legs_size": [
                3
            ],
            "rear_legs_size": [
                3
            ],
            "legs_separation": [
                3
            ],
            "central_rotation": [
                1
            ],
            "front_rotation": [
                2
            ],
            "rear_rotation": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "front_rear_bridging_bars_sizes": [
                2
            ],
            "front_rear_bridging_bars_offset": [
                2
            ],
            "left_right_bridging_bars_sizes": [
                2
            ],
            "left_right_bridging_bars_offset": [
                2
            ],
            "bridging_bars_existance": [
                4
            ],
            "additional_legs_params": [
                37
            ]
        },
        "Regular_partition": {
            "left_right_size": [
                3
            ],
            "rear_size": [
                2
            ],
            "left_right_separation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "has_partition": [
                3
            ]
        },
        "Regular_sublayer": {
            "subs_size": [
                3
            ],
            "number_of_subs": [
                1
            ],
            "subs_offset": [
                1
            ],
            "interval_between_subs": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "additional_sublayers_params": [
                178
            ]
        },
        "Bar_cylindrical_leg": {
            "vertical_size": [
                2
            ],
            "bottom_size": [
                2
            ],
            "horizontal_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "additional_legs_params": [
                37
            ]
        },
        "Star_leg": {
            "vertical_size": [
                2
            ],
            "sub_size": [
                3
            ],
            "number_of_sub_legs": [
                1
            ],
            "sub_central_offset": [
                1
            ],
            "tilt_angle": [
                1
            ],
            "central_rotation": [
                1
            ],
            "horizontal_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "additional_legs_params": [
                37
            ]
        },
        "Regular_drawer": {
            "number_of_drawer": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "drawers_params": [
                239
            ]
        },
        "Regular_backboard": {
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "size": [
                3
            ]
        },
        "Regular_door": {
            "number_of_door": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "doors_params": [
                52
            ]
        }
    },
    "Eyeglasses": {
        "Trapezoidal_Glasses": {
            "size": [
                4
            ],
            "interval": [
                1
            ],
            "glass_rotation": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "top_offset": [
                1
            ]
        },
        "Regular_Leg": {
            "size1": [
                3
            ],
            "size2": [
                3
            ],
            "rotation_1": [
                2
            ],
            "rotation_2": [
                2
            ],
            "offset_x": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "glass_interval": [
                1
            ]
        },
        "Standard_Support": {
            "size": [
                3
            ],
            "support_rotation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "offset_x": [
                1
            ]
        },
        "TrapezoidalFrame_Glasses": {
            "size": [
                4
            ],
            "interval": [
                1
            ],
            "width": [
                1
            ],
            "glass_rotation": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "top_offset": [
                1
            ]
        },
        "RoundFrame_Glasses": {
            "size": [
                3
            ],
            "interval": [
                1
            ],
            "width": [
                1
            ],
            "glass_rotation": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Leg": {
            "size1": [
                3
            ],
            "size2": [
                3
            ],
            "rotation_1": [
                2
            ],
            "rotation_2": [
                2
            ],
            "connector_size": [
                3
            ],
            "offset_x": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "glass_interval": [
                1
            ]
        },
        "Round_Glasses": {
            "size": [
                3
            ],
            "interval": [
                1
            ],
            "glass_rotation": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Dual_Connector": {
            "size_1": [
                3
            ],
            "offset_1": [
                3
            ],
            "size_2": [
                3
            ],
            "offset_2": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Standard_Connector": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Faucet": {
        "Cylindrical_Base": {
            "number_of_cylinder": [
                1
            ],
            "size_0": [
                2
            ],
            "size_1": [
                2
            ],
            "offset_1": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Lever_Switch": {
            "size": [
                2
            ],
            "R": [
                1
            ],
            "position0": [
                3
            ],
            "position1": [
                3
            ],
            "position2": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Spout": {
            "main_part_size": [
                2
            ],
            "head_size": [
                2
            ],
            "head_offset": [
                3
            ],
            "rotation_mainpart": [
                1
            ],
            "rotation_head": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Curved_Spout": {
            "R": [
                1
            ],
            "L": [
                1
            ],
            "bottom0": [
                3
            ],
            "bottom1": [
                3
            ],
            "center": [
                3
            ],
            "position": [
                3
            ],
            "spout_rotation": [
                1
            ],
            "rotation": [
                3
            ]
        },
        "UShapedXZ_Base": {
            "R": [
                1
            ],
            "size_tube": [
                2
            ],
            "size_base": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "RotaryZ_Switch": {
            "number_of_switch": [
                1
            ],
            "main_size_1": [
                2
            ],
            "main_size_2": [
                2
            ],
            "sub_size": [
                3
            ],
            "number_of_sub": [
                1
            ],
            "sub_offset": [
                1
            ],
            "tilt_angle": [
                1
            ],
            "rotation0": [
                1
            ],
            "rotation1": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "offset_x": [
                2
            ]
        },
        "RotaryX_Switch": {
            "existence_of_switch": [
                2
            ],
            "main_size_1": [
                2
            ],
            "main_size_2": [
                2
            ],
            "sub_size": [
                3
            ],
            "number_of_sub": [
                1
            ],
            "sub_offset": [
                1
            ],
            "tilt_angle": [
                1
            ],
            "rotation0": [
                1
            ],
            "rotation1": [
                1
            ],
            "position": [
                3
            ],
            "interval": [
                1
            ],
            "rotation": [
                3
            ],
            "offset_x": [
                2
            ]
        },
        "Cuboidal_Base": {
            "number_of_box": [
                1
            ],
            "size_0": [
                3
            ],
            "size_1": [
                3
            ],
            "offset_1": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "RotaryY_Switch": {
            "number_of_switch": [
                1
            ],
            "main_size_1": [
                2
            ],
            "main_size_2": [
                2
            ],
            "sub_size": [
                3
            ],
            "number_of_sub": [
                1
            ],
            "sub_offset": [
                1
            ],
            "tilt_angle": [
                1
            ],
            "rotation0": [
                1
            ],
            "rotation1": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "offset_x": [
                2
            ]
        },
        "Quadfold_Spout": {
            "R": [
                1
            ],
            "position0": [
                3
            ],
            "position1": [
                3
            ],
            "position2": [
                3
            ],
            "position3": [
                3
            ],
            "position4": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Spout": {
            "main_part_size": [
                3
            ],
            "head_size": [
                2
            ],
            "head_offset": [
                3
            ],
            "rotation_mainpart": [
                1
            ],
            "rotation_head": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Spout": {
            "R": [
                1
            ],
            "position0": [
                3
            ],
            "position1": [
                3
            ],
            "position2": [
                3
            ],
            "position3": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "RegularY_Switch": {
            "size": [
                2
            ],
            "sub_size": [
                2
            ],
            "sub_offset": [
                2
            ],
            "rotation_Y": [
                1
            ],
            "rotation_X": [
                1
            ],
            "sub_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "HandleY_Switch": {
            "number_of_cube": [
                1
            ],
            "number_of_switch": [
                1
            ],
            "bottom_size": [
                3
            ],
            "middle_size": [
                3
            ],
            "bottom_middle_offset": [
                2
            ],
            "offset_0_x": [
                1
            ],
            "offset_1_x": [
                1
            ],
            "offset_yz": [
                2
            ],
            "position": [
                3
            ],
            "top_size": [
                3
            ],
            "bottom_top_offset": [
                2
            ],
            "rotation": [
                3
            ]
        }
    },
    "KitchenPot": {
        "Cylindrical_Body": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Sidehandle": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Carved_Cylindrical_Cover": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Sidehandle": {
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ],
            "grip_size": [
                3
            ],
            "mounting_rotation": [
                1
            ],
            "handle_seperation": [
                1
            ],
            "rotation": [
                3
            ],
            "whole_rotation": [
                1
            ],
            "position": [
                3
            ]
        },
        "Semi_Spherical_Cover": {
            "radius": [
                1
            ],
            "exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Tophandle": {
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ],
            "grip_size": [
                3
            ],
            "mounting_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Tophandle": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Semi_Ring_Tophandle": {
            "curve_size": [
                3
            ],
            "curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "L_Shaped_Sidehandle": {
            "bottom_size": [
                3
            ],
            "top_size": [
                3
            ],
            "handle_seperation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Cover": {
            "size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Multilevel_Tophandle": {
            "num_levels": [
                1
            ],
            "level_1_size": [
                3
            ],
            "level_2_size": [
                3
            ],
            "level_3_size": [
                3
            ],
            "level_4_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Knife": {
        "Cylindrical_Handle": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Curved_Blade": {
            "root_size": [
                4
            ],
            "root_z_offset": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "tip_length": [
                1
            ],
            "tip_angle": [
                1
            ]
        },
        "Curved_Handle": {
            "radius": [
                2
            ],
            "rotation": [
                3
            ],
            "thickness": [
                1
            ],
            "exist_angle": [
                1
            ],
            "position": [
                3
            ]
        },
        "Enveloping_Handle": {
            "size": [
                3
            ],
            "thickness": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "gap_width": [
                1
            ]
        },
        "Cusp_Blade": {
            "root_size": [
                4
            ],
            "root_z_offset": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "tip_length": [
                1
            ],
            "tip_z_offset": [
                1
            ]
        },
        "Regular_Button": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Multideck_Handle": {
            "bottom_size": [
                3
            ],
            "beside_size": [
                3
            ],
            "beside_seperation": [
                1
            ],
            "beside_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Handle": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "T_Shaped_Handle": {
            "bottom_size": [
                3
            ],
            "bottom_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "main_size": [
                3
            ]
        }
    },
    "Pen": {
        "Cylindrical_Barrel": {
            "size": [
                3
            ],
            "thickness": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Refill": {
            "size": [
                2
            ],
            "tip_radius": [
                1
            ],
            "tip_height": [
                2
            ],
            "tip_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Curved_Clip": {
            "clip_curve_size": [
                3
            ],
            "clip_curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Bistratal_Button": {
            "bottom_size": [
                3
            ],
            "top_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Double_Layer_Barrel": {
            "main_size": [
                3
            ],
            "bottom_size": [
                2
            ],
            "thickness": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Clip": {
            "clip_root_size": [
                3
            ],
            "clip_vertical_size": [
                3
            ],
            "clip_tip_size": [
                3
            ],
            "clip_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Button": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Single_Cap": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Washingmachine": {
        "Cuboidal_Body": {
            "outer_size": [
                3
            ],
            "thickness": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Door": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Upright_Roller_Body": {
            "outer_size": [
                3
            ],
            "inner_size": [
                2
            ],
            "inner_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Front_Facing_Roller_Body": {
            "outer_size": [
                3
            ],
            "inner_size": [
                2
            ],
            "inner_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Roller_Door": {
            "circle_size": [
                3
            ],
            "middle_size": [
                2
            ],
            "middle_offset": [
                2
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Controller_With_Button": {
            "bottom_size": [
                4
            ],
            "button_1_size": [
                3
            ],
            "button_1_offset": [
                2
            ],
            "button_2_size": [
                3
            ],
            "button_2_offset": [
                2
            ],
            "button_3_size": [
                3
            ],
            "button_3_offset": [
                2
            ],
            "button_4_size": [
                3
            ],
            "button_4_offset": [
                2
            ],
            "button_5_size": [
                3
            ],
            "button_5_offset": [
                2
            ],
            "button_6_size": [
                3
            ],
            "button_6_offset": [
                2
            ],
            "button_7_size": [
                3
            ],
            "button_7_offset": [
                2
            ],
            "button_8_size": [
                3
            ],
            "button_8_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "num_buttons": [
                1
            ]
        }
    },
    "Refrigerator": {
        "Cuboidal_Body": {
            "size": [
                3
            ],
            "thickness": [
                5
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Door": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Drawer_Like_Tray": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Handle": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Multilevel_Leg": {
            "front_legs_size": [
                3
            ],
            "rear_legs_size": [
                3
            ],
            "legs_separation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "num_legs": [
                1
            ]
        },
        "Cuboidal_Vessel": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Left_Right_Double_Layer_Body": {
            "size": [
                3
            ],
            "clapboard_size": [
                2
            ],
            "clapboard_offset": [
                1
            ],
            "thickness": [
                5
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Handle": {
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ],
            "grip_size": [
                3
            ]
        },
        "Sunken_Door": {
            "size": [
                3
            ],
            "sunken_size": [
                3
            ],
            "sunken_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Curve_Handle": {
            "curve_size": [
                3
            ],
            "curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ]
        },
        "Double_Layer_Body": {
            "size": [
                3
            ],
            "clapboard_size": [
                2
            ],
            "clapboard_offset": [
                1
            ],
            "thickness": [
                5
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Curve_Handle": {
            "curve_size": [
                3
            ],
            "curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Flat_Tray": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Pliers": {
        "Round_Shaft": {
            "size": [
                2
            ],
            "central_shaft_size": [
                2
            ],
            "central_shaft_offset": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "has_central_shaft": [
                1
            ]
        },
        "Rectangular_Baffle": {
            "size": [
                3
            ],
            "baffle_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "baffle_rotation": [
                1
            ],
            "position": [
                3
            ]
        },
        "Cusp_Gripper": {
            "behind_size": [
                4
            ],
            "front_size": [
                4
            ],
            "gripper_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "gripper_rotation": [
                1
            ],
            "position": [
                3
            ]
        },
        "Straight_Handle": {
            "front_size": [
                3
            ],
            "behind_size": [
                3
            ],
            "handle_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "front_behind_offset": [
                2
            ],
            "left_right_offset": [
                1
            ],
            "handle_rotation": [
                2
            ],
            "position": [
                3
            ]
        },
        "Rectangular_Shaft": {
            "layer_1_size": [
                3
            ],
            "layer_2_size": [
                3
            ],
            "layer_2_offset": [
                2
            ],
            "layer_3_size": [
                3
            ],
            "layer_3_offset": [
                2
            ],
            "rotation": [
                3
            ],
            "central_shaft_size": [
                2
            ],
            "central_shaft_offset": [
                3
            ],
            "layer_rotation": [
                3
            ],
            "position": [
                3
            ],
            "num_layers": [
                1
            ],
            "has_central_shaft": [
                1
            ]
        },
        "Curved_Gripper": {
            "radius": [
                2
            ],
            "gripper_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "thickness": [
                1
            ],
            "gripper_rotation": [
                1
            ],
            "position": [
                3
            ]
        },
        "Rear_Curved_Handle": {
            "front_size": [
                3
            ],
            "behind_size": [
                3
            ],
            "handle_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "front_behind_offset": [
                2
            ],
            "left_right_offset": [
                1
            ],
            "handle_rotation": [
                2
            ],
            "exist_angle": [
                1
            ],
            "position": [
                3
            ]
        },
        "Curved_Baffle": {
            "radius": [
                2
            ],
            "height": [
                1
            ],
            "seperation_rotation": [
                1
            ],
            "exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Middle_Curved_Handle": {
            "front_size": [
                3
            ],
            "middle_size": [
                3
            ],
            "behind_size": [
                3
            ],
            "handle_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "front_middle_offset": [
                2
            ],
            "middle_behind_offset": [
                2
            ],
            "left_right_offset": [
                1
            ],
            "handle_rotation": [
                3
            ],
            "exist_angle": [
                1
            ],
            "position": [
                3
            ]
        }
    },
    "Microwave": {
        "Cuboidal_Body": {
            "size": [
                3
            ],
            "thickness": [
                5
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Curve_Handle": {
            "curve_size": [
                3
            ],
            "curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Controller_With_Button": {
            "bottom_size": [
                3
            ],
            "button_1_size": [
                3
            ],
            "button_2_size": [
                3
            ],
            "button_3_size": [
                3
            ],
            "button_4_size": [
                3
            ],
            "num_buttons": [
                1
            ],
            "button_1_offset": [
                2,
                3
            ],
            "button_2_offset": [
                2,
                3
            ],
            "button_3_offset": [
                2,
                3
            ],
            "button_4_offset": [
                2,
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Handle": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Tray": {
            "size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Sunken_Door": {
            "size": [
                3
            ],
            "sunken_size": [
                3
            ],
            "sunken_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Door": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Handle": {
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ],
            "grip_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Curve_Handle": {
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ],
            "curve_size": [
                3
            ],
            "curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Kettle": {
        "Multilevel_Body": {
            "num_levels": [
                1
            ],
            "level_1_bottom_radius": [
                2
            ],
            "level_1_top_radius": [
                2
            ],
            "level_1_height": [
                2
            ],
            "level_2_top_radius": [
                2
            ],
            "level_2_height": [
                1
            ],
            "level_3_top_radius": [
                2
            ],
            "level_3_height": [
                1
            ],
            "level_4_top_radius": [
                2
            ],
            "level_4_height": [
                1
            ],
            "level_5_top_radius": [
                2
            ],
            "level_5_height": [
                1
            ],
            "x_z_ratio": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Straight_Spout": {
            "num_of_sub_spouts": [
                1
            ],
            "spout_1_radius": [
                2
            ],
            "spout_1_thinkness": [
                1
            ],
            "spout_1_length": [
                2
            ],
            "spout_1_generatrix_offset": [
                1
            ],
            "spout_1_rotation": [
                1
            ],
            "spout_2_radius": [
                2
            ],
            "spout_2_thinkness": [
                1
            ],
            "spout_2_length": [
                2
            ],
            "spout_2_generatrix_offset": [
                1
            ],
            "spout_2_rotation": [
                1
            ],
            "spout_3_radius": [
                2
            ],
            "spout_3_thinkness": [
                1
            ],
            "spout_3_length": [
                2
            ],
            "spout_3_generatrix_offset": [
                1
            ],
            "spout_3_rotation": [
                1
            ],
            "spout_4_radius": [
                2
            ],
            "spout_4_thinkness": [
                1
            ],
            "spout_4_length": [
                2
            ],
            "spout_4_generatrix_offset": [
                1
            ],
            "spout_4_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Handle": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Curved_Spout": {
            "central_radius": [
                2
            ],
            "rotation": [
                3
            ],
            "exist_angle": [
                2
            ],
            "torus_radius": [
                3
            ],
            "position": [
                3
            ]
        },
        "Ring_Handle": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "exist_angle": [
                1
            ],
            "position": [
                3
            ]
        },
        "Standard_Cover": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "num_knobs": [
                1
            ],
            "knob_1_size": [
                3
            ],
            "knob_2_size": [
                3
            ],
            "knob_3_size": [
                3
            ],
            "knob_4_size": [
                3
            ],
            "knob_5_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Round_U_Handle": {
            "mounting_radius": [
                1
            ],
            "vertical_separation": [
                1
            ],
            "vertical_length": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Semi_Spherical_Body": {
            "horizontal_axis": [
                1
            ],
            "vertical_axis": [
                2
            ],
            "bottom_size": [
                2
            ],
            "exist_angle": [
                2
            ],
            "x_z_ratio": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Handle": {
            "horizontal_length": [
                2
            ],
            "horizontal_thickness": [
                2
            ],
            "vertical_thickness": [
                2
            ],
            "horizontal_rotation": [
                2
            ],
            "horizontal_separation": [
                1
            ],
            "mounting_offset": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Spherical_Cylindrical_Body": {
            "horizontal_axis": [
                1
            ],
            "vertical_axis": [
                1
            ],
            "bottom_size": [
                2
            ],
            "exist_angle": [
                1
            ],
            "x_z_ratio": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Flat_U_Handle": {
            "vertical_size": [
                3
            ],
            "vertical_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Curved_Handle": {
            "radius": [
                2
            ],
            "rotation": [
                3
            ],
            "exist_angle": [
                1
            ],
            "position": [
                3
            ]
        }
    },
    "Trashcan": {
        "Cylindrical_Body": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Shell": {
            "outer_size": [
                3
            ],
            "inner_size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Separated_Cylindrical_Body": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "clapboard_size": [
                3
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Prismatic_Body": {
            "top_size": [
                2
            ],
            "bottom_size": [
                2
            ],
            "height": [
                2
            ],
            "top_offset": [
                2
            ],
            "thickness": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Holed_Cylindrical_Cover": {
            "radius": [
                2
            ],
            "height": [
                3
            ],
            "rotation": [
                3
            ],
            "exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "num_sides": [
                1
            ]
        },
        "Holed_Cuboidal_Cover": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "front_behind_hole_size": [
                2
            ],
            "left_right_hole_size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "has_hole": [
                4
            ]
        },
        "Cylindrical_Cover": {
            "size": [
                2
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Cuboidal_Shell": {
            "outer_size": [
                3
            ],
            "inner_size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Hollow_Cover": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Cuboidal_Cover": {
            "top_size": [
                2
            ],
            "bottom_size": [
                2
            ],
            "height": [
                2
            ],
            "top_offset": [
                2
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Cuboidal_Hollow_Cover": {
            "outer_size": [
                3
            ],
            "inner_size": [
                2
            ],
            "inner_offset": [
                2
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Double_Layer_Cuboidal_Cover": {
            "top_size": [
                3
            ],
            "bottom_size": [
                3
            ],
            "top_offset": [
                2
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        }
    },
    "Dishwasher": {
        "Double_Layer_Body": {
            "size": [
                3
            ],
            "thickness": [
                5
            ],
            "clapboard_size": [
                3
            ],
            "clapboard_offset": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Door": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Body": {
            "size": [
                3
            ],
            "thickness": [
                5
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Sunken_Door": {
            "size": [
                3
            ],
            "sunken_size": [
                3
            ],
            "sunken_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Topcover": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Handle": {
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ],
            "grip_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Drawer_Like_Tray": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Multilevel_Leg": {
            "has_top_part": [
                1
            ],
            "top_size": [
                3
            ],
            "front_legs_size": [
                3
            ],
            "rear_legs_size": [
                3
            ],
            "num_legs": [
                1
            ],
            "top_bottom_offset": [
                2
            ],
            "legs_separation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Single_Leg": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Handle": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Trifold_Curve_Handle": {
            "mounting_size": [
                3
            ],
            "mounting_seperation": [
                1
            ],
            "curve_size": [
                3
            ],
            "curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Curve_Handle": {
            "curve_size": [
                3
            ],
            "curve_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Clip": {
        "Regular_lever": {
            "level_support_size": [
                3
            ],
            "level_support_seperation": [
                1
            ],
            "level_handle_size": [
                3
            ],
            "level_handle_offset": [
                1
            ],
            "level_handle_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Curved_jaw": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "jaw_separation": [
                1
            ],
            "position": [
                3
            ],
            "jaw_rotation": [
                1
            ],
            "central_angle": [
                1
            ]
        },
        "Regular_jaw": {
            "size": [
                3
            ],
            "rotation": [
                3
            ],
            "jaw_separation": [
                1
            ],
            "position": [
                3
            ],
            "jaw_rotation": [
                1
            ]
        }
    },
    "Dispenser": {
        "Multilevel_Body": {
            "num_levels": [
                1
            ],
            "level_1_size": [
                3
            ],
            "level_2_size": [
                2
            ],
            "level_3_size": [
                2
            ],
            "level_4_size": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Spray_Nozzle": {
            "bottom_size": [
                2
            ],
            "middle_size": [
                3
            ],
            "top_size": [
                3
            ],
            "top_offset": [
                2
            ],
            "top_rotation": [
                1
            ],
            "nozzle_size": [
                2
            ],
            "handle_size": [
                3
            ],
            "handle_offset": [
                1
            ],
            "handle_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Body": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Press_Nozzle": {
            "num_levels": [
                1
            ],
            "level_1_size": [
                2
            ],
            "level_2_size": [
                2
            ],
            "level_3_size": [
                2
            ],
            "level_4_size": [
                2
            ],
            "level_5_size": [
                2
            ],
            "num_nozzles": [
                1
            ],
            "nozzle_size": [
                2
            ],
            "nozzle_length": [
                2
            ],
            "nozzle_offset": [
                1
            ],
            "nozzle_rotation": [
                1,
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Bucket": {
        "Cylindrical_Body": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Single_Cylinder": {
            "size": [
                2
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Curved_Handle": {
            "radius": [
                2
            ],
            "rotation": [
                3
            ],
            "exist_angle": [
                1
            ],
            "position": [
                3
            ]
        },
        "Prismatic_Body": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Flat_U_Handle": {
            "vertical_size": [
                3
            ],
            "vertical_separation": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Round_U_Handle": {
            "inner_radius": [
                1
            ],
            "vertical_separation": [
                1
            ],
            "vertical_length": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ]
        },
        "Trifold_Handle": {
            "vertical_length": [
                2
            ],
            "vertical_thickness": [
                2
            ],
            "horizontal_thickness": [
                2
            ],
            "vertical_rotation": [
                2
            ],
            "vertical_separation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Shampoo": {
        "Cylindrical_body": {
            "num_of_part": [
                1
            ],
            "x_z_ratio": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "all_sizes": [
                9
            ]
        },
        "Cylindrical_cap": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "x_z_ratio": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Toothpaste_body": {
            "radius": [
                1
            ],
            "bottom_length": [
                1
            ],
            "height": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_body": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Regular_nozzle": {
            "num_of_part": [
                1
            ],
            "num_of_nozzle": [
                1
            ],
            "nozzle_size": [
                2
            ],
            "nozzle_length": [
                1,
                2
            ],
            "nozzle_offset": [
                1
            ],
            "nozzle_rotation": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "parts_params": [
                10
            ]
        }
    },
    "Globe": {
        "Standard_Sphere": {
            "radius": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Enclosed_Bracket": {
            "bracket_size": [
                3
            ],
            "circle_radius": [
                1
            ],
            "half_circle_number": [
                1
            ],
            "circle_thickness": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Table_Like_Base": {
            "circle_size": [
                3
            ],
            "leg_size": [
                2
            ],
            "leg_seperation": [
                1
            ],
            "bottom_size": [
                3
            ],
            "bottom_offset": [
                1
            ],
            "rotation": [
                3
            ],
            "position": [
                3
            ],
            "num_legs": [
                1
            ],
            "has_bottom_part": [
                1
            ]
        },
        "Semi_Ring_Bracket": {
            "pivot_size": [
                2
            ],
            "pivot_continuity": [
                1
            ],
            "pivot_seperation": [
                1
            ],
            "endpoint_radius": [
                1
            ],
            "bracket_size": [
                3
            ],
            "bracket_offset": [
                1
            ],
            "bracket_rotation": [
                1
            ],
            "bracket_exist_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "has_top_endpoint": [
                1
            ],
            "has_bottom_endpoint": [
                1
            ]
        },
        "Cuboidal_Base": {
            "bottom_size": [
                3
            ],
            "top_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Special_Base": {
            "radius": [
                2
            ],
            "top_size": [
                2
            ],
            "top_rotation": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Tilted_Bracket": {
            "pivot_size": [
                2
            ],
            "bracket_size": [
                3
            ],
            "circle_rotation": [
                1
            ],
            "circle_thickness": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Base": {
            "bottom_size": [
                3
            ],
            "top_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Star_Shaped_Base": {
            "top_size": [
                2
            ],
            "sub_size": [
                3
            ],
            "tilt_angle": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "num_legs": [
                1
            ]
        }
    },
    "Stapler": {
        "Standard_Body": {
            "base_size": [
                3
            ],
            "beside_size": [
                3
            ],
            "beside_seperation": [
                1
            ],
            "beside_offset_z": [
                1
            ],
            "has_shaft": [
                1
            ],
            "shaft_central_size": [
                2
            ],
            "shaft_beside_size": [
                2
            ],
            "shaft_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Carved_Cover": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Carved_Magazine": {
            "outer_size": [
                3
            ],
            "inner_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Simplified_Cover": {
            "size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Complex_Magazine": {
            "size": [
                3
            ],
            "thickness": [
                1
            ],
            "front_height": [
                1
            ],
            "beside_length": [
                1
            ],
            "beside_offset": [
                1
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    },
    "Window": {
        "Asymmetrical_Window": {
            "number_of_window": [
                1
            ],
            "size_0": [
                2
            ],
            "size_1": [
                2
            ],
            "size_2": [
                2
            ],
            "size_3": [
                2
            ],
            "glass_size_0": [
                3
            ],
            "glass_size_1": [
                3
            ],
            "glass_size_2": [
                3
            ],
            "glass_size_3": [
                3
            ],
            "glass_offset_0": [
                3
            ],
            "glass_offset_1": [
                3
            ],
            "glass_offset_2": [
                3
            ],
            "glass_offset_3": [
                3
            ],
            "offset_x": [
                6
            ],
            "offset_z": [
                1
            ],
            "outside_frame_inner_size": [
                2
            ],
            "outside_frame_inner_outer_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Standard_Windowframe": {
            "size": [
                3
            ],
            "inner_size": [
                2
            ],
            "inner_outer_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Arched_Handle": {
            "num_of_handle": [
                2
            ],
            "outer_size": [
                3
            ],
            "bottom_size": [
                3
            ],
            "offset_x": [
                4
            ],
            "seperation": [
                1
            ],
            "thinner_handle": [
                1
            ],
            "window_type": [
                1
            ],
            "handle_z_position": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "windows_size.size_0": [
                2
            ],
            "windows_size.size_1": [
                2
            ],
            "windows_size.size_2": [
                2
            ],
            "windows_size.size_3": [
                2
            ]
        },
        "Symmetrical_Window": {
            "number_of_window": [
                1
            ],
            "symmetryOrNot": [
                1
            ],
            "size_0": [
                2
            ],
            "size_1": [
                2
            ],
            "size_2": [
                2
            ],
            "glass_size_0": [
                3
            ],
            "glass_size_1": [
                3
            ],
            "glass_size_2": [
                3
            ],
            "glass_offset_0": [
                3
            ],
            "glass_offset_1": [
                3
            ],
            "glass_offset_2": [
                3
            ],
            "offset_x": [
                6
            ],
            "offset_z": [
                1
            ],
            "outside_frame_inner_size": [
                2
            ],
            "outside_frame_inner_outer_offset": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cuboidal_Handle": {
            "num_of_handle": [
                2
            ],
            "size": [
                3
            ],
            "offset_x": [
                4
            ],
            "window_type": [
                1
            ],
            "handle_z_position": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "windows_size.size_0": [
                2
            ],
            "windows_size.size_1": [
                2
            ],
            "windows_size.size_2": [
                2
            ],
            "windows_size.size_3": [
                2
            ]
        },
        "LShaped_Handle": {
            "num_of_handle": [
                2
            ],
            "window_type": [
                1
            ],
            "size_bottom": [
                3
            ],
            "size_middle": [
                3
            ],
            "size_top": [
                3
            ],
            "offset_x": [
                4
            ],
            "offset_middle_y": [
                1
            ],
            "offset_top_y": [
                1
            ],
            "handle_z_position": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ],
            "windows_size.size_0": [
                2
            ],
            "windows_size.size_1": [
                2
            ],
            "windows_size.size_2": [
                2
            ],
            "windows_size.size_3": [
                2
            ]
        }
    },
    "Door": {
        "Standard_Door": {
            "existence_of_door": [
                2
            ],
            "size": [
                3
            ],
            "door_rotation": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Standard_Doorframe": {
            "main_outer_size": [
                3
            ],
            "main_inner_outer_offset": [
                2
            ],
            "main_offset": [
                2
            ],
            "sub1_outer_size": [
                3
            ],
            "sub1_inner_size": [
                2
            ],
            "sub1_inner_outer_offset": [
                2
            ],
            "sub1_offset": [
                2
            ],
            "sub2_outer_size": [
                3
            ],
            "sub2_inner_size": [
                2
            ],
            "sub2_inner_outer_offset": [
                2
            ],
            "sub2_offset": [
                2
            ],
            "door_size": [
                3
            ],
            "existence_of_doorframe": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Standard_Hinge": {
            "number_of_hinge": [
                1
            ],
            "size": [
                2
            ],
            "separation": [
                4
            ],
            "offset_1": [
                3
            ],
            "offset_2": [
                3
            ],
            "existence_of_door": [
                2
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "PiShape_Handle": {
            "existence_of_handle": [
                2
            ],
            "main_size": [
                3
            ],
            "sub_size": [
                3
            ],
            "separation": [
                1
            ],
            "interpiece_offset": [
                1
            ],
            "offset_x": [
                2
            ],
            "door_rotation": [
                2
            ],
            "existence_of_door": [
                2
            ],
            "door_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "LShape_Handle": {
            "existence_of_handle": [
                2
            ],
            "fixed_part_size": [
                3
            ],
            "vertical_movable_size": [
                3
            ],
            "horizontal_movable_size": [
                3
            ],
            "interpiece_offset": [
                2
            ],
            "offset_x": [
                2
            ],
            "door_rotation": [
                2
            ],
            "existence_of_door": [
                2
            ],
            "door_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Cylindrical_Handle": {
            "existence_of_handle": [
                2
            ],
            "fixed_part_size": [
                2
            ],
            "sub_size": [
                2
            ],
            "main_size": [
                2
            ],
            "offset_x": [
                2
            ],
            "door_rotation": [
                2
            ],
            "existence_of_door": [
                2
            ],
            "door_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        },
        "Spherical_Handle": {
            "existence_of_handle": [
                2
            ],
            "fixed_part_size": [
                2
            ],
            "sub_size": [
                2
            ],
            "main_size": [
                3
            ],
            "offset_x": [
                2
            ],
            "door_rotation": [
                2
            ],
            "existence_of_door": [
                2
            ],
            "door_size": [
                3
            ],
            "position": [
                3
            ],
            "rotation": [
                3
            ]
        }
    }
}
