import json
from .param_dims import param_dims

examples = {
    "Chair": {
        "category": "Chair",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                10,
                -150,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "Regular_seat",
                "parameters": {
                    "size": [
                        1.0142278923638715,
                        0.15439544704886746,
                        0.9911534321084432
                    ],
                    "position": [
                        0.000102673796791444,
                        -0.08650534759358292,
                        0.12317058823529413
                    ],
                    "rotation": [
                        -1.0310160427807487,
                        -0.01229946524064171,
                        0.008877005347593584
                    ]
                }
            },
            {
                "template": "Star_leg",
                "parameters": {
                    "vertical_sizes": [
                        0.06109356084902978,
                        0.5974106048246444
                    ],
                    "sub_sizes": [
                        0.03054678042451489,
                        0.09164034127354467,
                        0.47792848385971554
                    ],
                    "number_of_sub_legs": [
                        4.0
                    ],
                    "sub_central_offset": [
                        0.01525
                    ],
                    "tilt_angle": [
                        8.40895130188202
                    ],
                    "central_rotation": [
                        23.36737177518531
                    ],
                    "horizontal_rotation": [
                        0.0
                    ],
                    "position": [
                        0.000102673796791444,
                        -0.46387631626368736,
                        0.12317058823529413
                    ],
                    "rotation": [
                        -1.0310160427807487,
                        -0.01229946524064171,
                        0.008877005347593584
                    ]
                }
            },
            {
                "template": "Office_armrest",
                "parameters": {
                    "armrest_separation": [
                        0.8511777759428211
                    ],
                    "rotation": [
                        -1.0310160427807487,
                        -0.01229946524064171,
                        0.008877005347593584
                    ],
                    "position": [
                        0.000102673796791444,
                        -0.08650534759358292,
                        0.12317058823529413
                    ],
                    "horizontal_support_sizes": [
                        0.10531089835073083,
                        0.0714408064189108,
                        0.7870139942897498
                    ],
                    "vertical_support_sizes": [
                        0.088803550527166,
                        0.5215779939017925,
                        0.10390298743598293
                    ],
                    "supports_contact_offset": [
                        0.17087060410105828
                    ],
                    "vertical_support_rotation": [
                        34.64704532051716
                    ],
                    "horizontal_support_rotation": [
                        0.3731458920719349
                    ],
                    "armrest_rotation": [
                        1.3205915334703504
                    ]
                }
            },
            {
                "template": "Solid_back",
                "parameters": {
                    "size": [
                        0.8833389749776406,
                        0.7855845161593031,
                        0.16431342641650254
                    ],
                    "rotation": [
                        -1.0310160427807487,
                        -0.01229946524064171,
                        0.008877005347593584
                    ],
                    "position": [
                        0.000102673796791444,
                        -0.08650534759358292,
                        -0.37100971715164643
                    ],
                    "back_rotation": [
                        -7.295315254505346
                    ]
                }
            }
        ]
    },
    "Door": {
        "category": "Door",
        "pose": {
            "global_position": [
                0,
                0,
                0
            ],
            "global_rotation": [
                10,
                -160,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "Standard_Door",
                "parameters": {
                    "existence_of_door": [
                        0.0,
                        1.0
                    ],
                    "size": [
                        0.6446001934378058,
                        1.6192630181214513,
                        0.04163641287030173
                    ],
                    "door_rotation": [
                        85.84096022780572,
                        2.1977745388956267
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Standard_Doorframe",
                "parameters": {
                    "main_outer_size": [
                        0.8130467599645215,
                        1.6678440088300255,
                        0.09808771217435493
                    ],
                    "main_inner_outer_offset": [
                        0.0,
                        0.0
                    ],
                    "main_offset": [
                        0.0,
                        0.0
                    ],
                    "sub1_outer_size": [
                        0.7975896087070702,
                        1.665106650029802,
                        0.03125364394438753
                    ],
                    "sub1_inner_size": [
                        0.64435135967846,
                        1.6192630181214513
                    ],
                    "sub1_inner_outer_offset": [
                        0.0,
                        0.0
                    ],
                    "sub1_offset": [
                        0.0,
                        0.0
                    ],
                    "sub2_outer_size": [
                        0.7975896087070702,
                        1.665106650029802,
                        0.07255940246776385
                    ],
                    "sub2_inner_size": [
                        0.64435135967846,
                        1.6192630181214513
                    ],
                    "sub2_inner_outer_offset": [
                        0.0,
                        0.0
                    ],
                    "sub2_offset": [
                        0.0,
                        0.0
                    ],
                    "door_size": [
                        0.64435135967846,
                        1.6192630181214513,
                        0.04163641287030173
                    ],
                    "existence_of_doorframe": [
                        1.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Standard_Hinge",
                "parameters": {
                    "number_of_hinge": [
                        4.0
                    ],
                    "size": [
                        0.004078775596619251,
                        0.0818713081890344
                    ],
                    "separation": [
                        0.28702614214202554,
                        0.29704205283162655,
                        0.2932618484379281,
                        0.28546965131695407
                    ],
                    "offset_1": [
                        0.3227278365644461,
                        -0.5697877974080532,
                        0.0
                    ],
                    "offset_2": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "existence_of_door": [
                        0.0,
                        1.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "LShape_Handle",
                "parameters": {
                    "existence_of_handle": [
                        1.0,
                        1.0
                    ],
                    "fixed_part_size": [
                        0.04160951955865504,
                        0.036472430364100535,
                        0.00887469586778995
                    ],
                    "vertical_movable_size": [
                        0.02826866596446074,
                        0.016964513908310674,
                        0.011277926897283646
                    ],
                    "horizontal_movable_size": [
                        0.08758423064364608,
                        0.018474585979783142,
                        0.016589423580832992
                    ],
                    "interpiece_offset": [
                        0.0,
                        0.0
                    ],
                    "offset_x": [
                        0.2314417374062131,
                        0.06104820963075355
                    ],
                    "door_rotation": [
                        85.95616756183314,
                        2.21568144314168
                    ],
                    "existence_of_door": [
                        0.0,
                        1.0
                    ],
                    "door_size": [
                        0.6444668756365484,
                        1.6204184231663805,
                        0.04163717094395806
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    },
    "Eyeglasses": {
        "category": "Eyeglasses",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -10,
                -160,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "TrapezoidalFrame_Glasses",
                "parameters": {
                    "size": [
                        0.6313334093029325,
                        0.4544358498083012,
                        0.37550081217833914,
                        0.04861040271824187
                    ],
                    "interval": [
                        0.05749036476065299
                    ],
                    "width": [
                        0.03181673693088945
                    ],
                    "glass_rotation": [
                        7.998948548772653,
                        5.068231942495174
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "top_offset": [
                        0.0
                    ]
                }
            },
            {
                "template": "Regular_Leg",
                "parameters": {
                    "size1": [
                        0.03861971996381988,
                        0.04410391957262661,
                        0.7986324911524544
                    ],
                    "size2": [
                        0.034678753940679784,
                        0.03773884265892594,
                        0.4483871830642022
                    ],
                    "rotation_1": [
                        2.869261846365899,
                        -80.52746581025706
                    ],
                    "rotation_2": [
                        22.40013642367343,
                        -9.577265623091062
                    ],
                    "offset_x": [
                        0.02817185755211179
                    ],
                    "position": [
                        0.0,
                        0.15402966385049766,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "glass_interval": 1.2423407438293343
                }
            }
        ]
    },
    "Faucet": {
        "category": "Faucet",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                30,
                10,
                -10
            ]
        },
        "conceptualization": [
            {
                "template": "UShapedXZ_Base",
                "parameters": {
                    "R": [
                        0.07158023957421121
                    ],
                    "size_tube": [
                        0.7773063762189255,
                        0.11011063104636346
                    ],
                    "size_base": [
                        0.08532998949838075,
                        0.13181671369265835
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "RotaryZ_Switch",
                "parameters": {
                    "number_of_switch": [
                        1.0
                    ],
                    "main_size_1": [
                        0.12622699113744537,
                        0.2276590185521374
                    ],
                    "main_size_2": [
                        0.05952755462155017,
                        0.014375661217018925
                    ],
                    "sub_size": [
                        0.23110765977806882,
                        0.08900120343077499,
                        0.04180128308228032
                    ],
                    "number_of_sub": [
                        1.0
                    ],
                    "sub_offset": [
                        0.04368692186591699
                    ],
                    "tilt_angle": [
                        6.605578212449456
                    ],
                    "rotation0": [
                        38.41543649667827
                    ],
                    "rotation1": [
                        15.786423294328495
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.31318700798868826
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "offset_x": [
                        0.0,
                        0.2619440890793869
                    ]
                }
            },
            {
                "template": "Curved_Spout",
                "parameters": {
                    "R": [
                        0.05835676328821287
                    ],
                    "L": [
                        0.18255301254969786
                    ],
                    "bottom0": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "bottom1": [
                        0.0,
                        0.4481783014754736,
                        0.010040440368296918
                    ],
                    "center": [
                        0.0,
                        0.0,
                        0.3509855666803457
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.2356183900827447
                    ],
                    "spout_rotation": [
                        138.34241589473373
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    },
    "Globe": {
        "category": "Globe",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                20,
                120,
                10
            ]
        },
        "conceptualization": [
            {
                "template": "Standard_Sphere",
                "parameters": {
                    "radius": [
                        0.47880751832283286
                    ],
                    "position": [
                        -0.0025394736842105276,
                        0.17076315789473678,
                        0.013697368421052637
                    ],
                    "rotation": [
                        -0.015789473684210527,
                        -11.463157894736842,
                        -0.042105263157894736
                    ]
                }
            },
            {
                "template": "Cylindrical_Base",
                "parameters": {
                    "bottom_size": [
                        0.3136711453283349,
                        0.3265664853697974,
                        0.05647943451269169
                    ],
                    "top_size": [
                        0.01,
                        0.14087907160991742,
                        0.06242867882462527
                    ],
                    "position": [
                        -0.0025394736842105276,
                        -0.4389831402152341,
                        0.013697368421052637
                    ],
                    "rotation": [
                        -0.015789473684210527,
                        -11.463157894736842,
                        -0.042105263157894736
                    ]
                }
            },
            {
                "template": "Semi_Ring_Bracket",
                "parameters": {
                    "pivot_size": [
                        0.02281761402287235,
                        0.11496163858378369
                    ],
                    "pivot_continuity": [
                        0.0
                    ],
                    "pivot_seperation": [
                        0.9582523265392053
                    ],
                    "endpoint_radius": [
                        0.06617108066632982
                    ],
                    "bracket_size": [
                        0.5943480854726417,
                        0.5381638336313092,
                        0.047923698651158995
                    ],
                    "bracket_offset": [
                        0.0
                    ],
                    "bracket_rotation": [
                        166.43340899487998
                    ],
                    "bracket_exist_angle": [
                        216.48500992415057
                    ],
                    "position": [
                        -0.0025394736842105276,
                        0.17076315789473678,
                        0.013697368421052637
                    ],
                    "rotation": [
                        -0.015789473684210527,
                        -11.463157894736842,
                        -0.042105263157894736
                    ],
                    "has_top_endpoint": [
                        0.0
                    ],
                    "has_bottom_endpoint": [
                        0.0
                    ]
                }
            }
        ]
    },
    "Knife": {
        "category": "Knife",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -40,
                -70,
                -40
            ]
        },
        "conceptualization": [
            {
                "template": "Multideck_Handle",
                "parameters": {
                    "bottom_size": [
                        0.13845784824944185,
                        0.0837504082446593,
                        0.22591979882723237
                    ],
                    "beside_size": [
                        0.05114446651738023,
                        0.7368363624653965,
                        0.22591979882723237
                    ],
                    "beside_seperation": [
                        0.08750199455843244
                    ],
                    "beside_offset": [
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Cusp_Blade",
                "parameters": {
                    "root_size": [
                        0.0362075705751479,
                        0.5645723744563047,
                        0.19406498527608518,
                        0.19406498527608518
                    ],
                    "root_z_offset": [
                        0.0
                    ],
                    "rotation": [
                        132.0,
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.36843314046363473,
                        0.0
                    ],
                    "tip_length": [
                        0.17267347509463163
                    ],
                    "tip_z_offset": [
                        0.0
                    ]
                }
            }
        ]
    },
    "Laptop": {
        "category": "Laptop",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -40,
                -10,
                20
            ]
        },
        "conceptualization": [
            {
                "template": "Regular_Base",
                "parameters": {
                    "size": [
                        1.30382260766135,
                        0.054582041603897714,
                        0.7735982071254445
                    ],
                    "position": [
                        0.0020729166666666665,
                        -0.19281666666666672,
                        0.2589270833333333
                    ],
                    "rotation": [
                        0.13333333333333333,
                        -0.011874999999999997,
                        0.016666666666666666
                    ]
                }
            },
            {
                "template": "Regular_Screen",
                "parameters": {
                    "size": [
                        1.2987789197499773,
                        0.7696931668482077,
                        0.03962654958670797
                    ],
                    "offset": [
                        0.027309566317707687,
                        -0.40032419882067244
                    ],
                    "screen_rotation": [
                        -12.772031413176489
                    ],
                    "position": [
                        0.0020729166666666665,
                        -0.19281666666666672,
                        0.2589270833333333
                    ],
                    "rotation": [
                        0.13333333333333333,
                        -0.011874999999999997,
                        0.016666666666666666
                    ]
                }
            },
            {
                "template": "Cylindrical_Connector",
                "parameters": {
                    "number_of_connector": [
                        3.0
                    ],
                    "size": [
                        0.02360671581338379,
                        0.17107433903792163
                    ],
                    "separation": [
                        0.39675397926263445,
                        0.39696810554931483,
                        0.3978128586874336,
                        0.14749999999999994
                    ],
                    "offset": [
                        -0.651561221105586,
                        0.02729824505214187,
                        -0.3139069836068757
                    ],
                    "position": [
                        0.0020729166666666665,
                        -0.19281666666666672,
                        0.2589270833333333
                    ],
                    "rotation": [
                        0.13333333333333333,
                        -0.011874999999999997,
                        0.016666666666666666
                    ]
                }
            }
        ]
    },
    "Microwave": {
        "category": "Microwave",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -20,
                20,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "Cuboidal_Body",
                "parameters": {
                    "size": [
                        2.542661114464916,
                        1.6022280666324862,
                        1.6378984295133079
                    ],
                    "thickness": [
                        0.10230683278001476,
                        0.10230683278001476,
                        0.07679753817975903,
                        0.07679753817975903,
                        0.10230683278001476
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Controller_With_Button",
                "parameters": {
                    "bottom_size": [
                        0.5966583762211253,
                        1.6036173442051918,
                        0.07694630487201597
                    ],
                    "button_1_size": [
                        0.2,
                        0.2,
                        0.12
                    ],
                    "button_2_size": [
                        0.2,
                        0.2,
                        0.12
                    ],
                    "button_3_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_4_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "num_buttons": [
                        2.0
                    ],
                    "button_1_offset": [
                        0.0,
                        -0.36,
                        0.0
                    ],
                    "button_2_offset": [
                        0.0,
                        0.36,
                        0.0
                    ],
                    "button_3_offset": [
                        0.0,
                        0.0
                    ],
                    "button_4_offset": [
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.9807601747402869,
                        0.0,
                        0.8192206482422426
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Curve_Handle",
                "parameters": {
                    "curve_size": [
                        1.116298567800364,
                        1.056298567800364,
                        0.07423221938333222
                    ],
                    "curve_exist_angle": [
                        75.0
                    ],
                    "position": [
                        0.39684580991536783,
                        0.0,
                        1.082857830709068
                    ],
                    "rotation": [
                        0.0,
                        -5.707825852018129,
                        0.0
                    ]
                }
            },
            {
                "template": "Sunken_Door",
                "parameters": {
                    "size": [
                        1.9426890329117734,
                        1.6020709981654833,
                        0.07692169050549198
                    ],
                    "sunken_size": [
                        1.6472444160213893,
                        1.0124201535229644,
                        0.04564542874652648
                    ],
                    "sunken_offset": [
                        0.0,
                        0.0
                    ],
                    "position": [
                        -0.34001405891423997,
                        0.0,
                        0.8932907897332549
                    ],
                    "rotation": [
                        0.0,
                        -3.7558202215459358,
                        0.0
                    ]
                }
            }
        ]
    },
    "Mug": {
        "category": "Mug",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                30,
                -60,
                -30
            ]
        },
        "conceptualization": [
            {
                "template": "Cylindrical_Body",
                "parameters": {
                    "outer_size": [
                        0.46864146432197185,
                        0.49281171577659594,
                        1.0362003008472067
                    ],
                    "inner_size": [
                        0.4181194242192834,
                        0.4019962226496904,
                        0.9418443852165674
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Single_Cylinder",
                "parameters": {
                    "size": [
                        0.46798840079148135,
                        0.031720363472804804
                    ],
                    "position": [
                        0.0009719486115468495,
                        0.5327157955775185,
                        0.014052830418131304
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Curved_Handle",
                "parameters": {
                    "radius": [
                        0.36917126375880077,
                        0.04076364977665022
                    ],
                    "rotation": [
                        -0.4326530612244899,
                        -0.20408163265306126,
                        0.04489795918367347
                    ],
                    "central_angle": [
                        189.72912611261586
                    ],
                    "position": [
                        -0.004240744577540699,
                        0.10842704188845965,
                        0.473192720175318
                    ]
                }
            }
        ]
    },
    "Oven": {
        "category": "Oven",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -10,
                20,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "Cuboidal_Body",
                "parameters": {
                    "size": [
                        1.4000919099252338,
                        1.1474674966760114,
                        0.5893863193284186
                    ],
                    "thickness": [
                        0.05732285829101197,
                        0.030375859140089116,
                        0.03009872498959114,
                        0.03009872498959114,
                        0.044831792743669094
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Multilevel_Leg",
                "parameters": {
                    "front_legs_size": [
                        1.2358401322220858,
                        0.04457183536855425,
                        0.4721019548845441
                    ],
                    "rear_legs_size": [
                        0.10250000000000001,
                        0.05075000000000002,
                        0.10250000000000001
                    ],
                    "num_legs": [
                        1.0
                    ],
                    "legs_separation": [
                        0.17853686869896135,
                        1.1972630346312354,
                        0.0
                    ],
                    "position": [
                        0.0,
                        -0.5729382889183777,
                        -0.16704695784525317
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Drawer_Like_Tray",
                "parameters": {
                    "outer_size": [
                        1.296157500738101,
                        0.03573917351208952,
                        0.48072848478481095
                    ],
                    "inner_size": [
                        1.0173627622656107,
                        0.026868838331413,
                        0.43912930553411283
                    ],
                    "position": [
                        0.0,
                        0.27856440316149145,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Trifold_Curve_Handle",
                "parameters": {
                    "mounting_size": [
                        0.03597633972174157,
                        0.022614988237496077,
                        0.03448635333061884
                    ],
                    "mounting_seperation": [
                        0.8073549859274995
                    ],
                    "curve_size": [
                        1.5522622668721255,
                        1.5190190168934399,
                        0.03597633972174157
                    ],
                    "curve_exist_angle": [
                        30.928196995284452
                    ],
                    "position": [
                        0.0,
                        0.5145191674116951,
                        0.34510543026563
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        90.0
                    ]
                }
            },
            {
                "template": "Controller_With_Button",
                "parameters": {
                    "bottom_size": [
                        1.3998099962057708,
                        0.12437039695086129,
                        0.04563245918950896,
                        0.05213585848005925
                    ],
                    "button_1_size": [
                        0.05955819617111099,
                        0.07002250480972652,
                        0.02902264959652385
                    ],
                    "button_1_offset": [
                        -0.5765984453226248,
                        0.0
                    ],
                    "button_2_size": [
                        0.05955819617111099,
                        0.07002250480972652,
                        0.02902264959652385
                    ],
                    "button_2_offset": [
                        -0.19179919050117442,
                        0.0
                    ],
                    "button_3_size": [
                        0.05955819617111099,
                        0.07002250480972652,
                        0.02902264959652385
                    ],
                    "button_3_offset": [
                        0.19691556836222712,
                        0.0
                    ],
                    "button_4_size": [
                        0.05955819617111099,
                        0.07002250480972652,
                        0.02902264959652385
                    ],
                    "button_4_offset": [
                        0.5907467050866813,
                        0.0
                    ],
                    "button_5_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_5_offset": [
                        0.0,
                        0.0
                    ],
                    "button_6_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_6_offset": [
                        0.0,
                        0.0
                    ],
                    "button_7_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_7_offset": [
                        0.0,
                        0.0
                    ],
                    "button_8_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_8_offset": [
                        0.0,
                        0.0
                    ],
                    "button_9_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_9_offset": [
                        0.0,
                        0.0
                    ],
                    "button_10_size": [
                        0.04100000000000001,
                        0.04072222222222223,
                        0.03916666666666667
                    ],
                    "button_10_offset": [
                        0.02525,
                        0.0005555555555555556
                    ],
                    "num_buttons": [
                        4.0
                    ],
                    "position": [
                        0.0,
                        0.5207695818260706,
                        0.29504659276885625
                    ],
                    "rotation": [
                        0.0,
                        -0.2111111111111111,
                        0.0
                    ]
                }
            },
            {
                "template": "Sunken_Door",
                "parameters": {
                    "size": [
                        1.4004965740992157,
                        1.044063465872213,
                        0.04709140004200215
                    ],
                    "sunken_size": [
                        1.3235784505165549,
                        0.8728257757223529,
                        0.040171602243911246
                    ],
                    "sunken_offset": [
                        0.0,
                        -0.029363960284471108
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.29567236737217584
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    },
    "Pen": {
        "category": "Oven",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -10,
                20,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "Cuboidal_Body",
                "parameters": {
                    "size": [
                        1.4000919099252338,
                        1.1474674966760114,
                        0.5893863193284186
                    ],
                    "thickness": [
                        0.05732285829101197,
                        0.030375859140089116,
                        0.03009872498959114,
                        0.03009872498959114,
                        0.044831792743669094
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Multilevel_Leg",
                "parameters": {
                    "front_legs_size": [
                        1.2358401322220858,
                        0.04457183536855425,
                        0.4721019548845441
                    ],
                    "rear_legs_size": [
                        0.10250000000000001,
                        0.05075000000000002,
                        0.10250000000000001
                    ],
                    "num_legs": [
                        1.0
                    ],
                    "legs_separation": [
                        0.17853686869896135,
                        1.1972630346312354,
                        0.0
                    ],
                    "position": [
                        0.0,
                        -0.5729382889183777,
                        -0.16704695784525317
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Drawer_Like_Tray",
                "parameters": {
                    "outer_size": [
                        1.296157500738101,
                        0.03573917351208952,
                        0.48072848478481095
                    ],
                    "inner_size": [
                        1.0173627622656107,
                        0.026868838331413,
                        0.43912930553411283
                    ],
                    "position": [
                        0.0,
                        0.27856440316149145,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Trifold_Curve_Handle",
                "parameters": {
                    "mounting_size": [
                        0.03597633972174157,
                        0.022614988237496077,
                        0.03448635333061884
                    ],
                    "mounting_seperation": [
                        0.8073549859274995
                    ],
                    "curve_size": [
                        1.5522622668721255,
                        1.5190190168934399,
                        0.03597633972174157
                    ],
                    "curve_exist_angle": [
                        30.928196995284452
                    ],
                    "position": [
                        0.0,
                        0.5145191674116951,
                        0.34510543026563
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        90.0
                    ]
                }
            },
            {
                "template": "Controller_With_Button",
                "parameters": {
                    "bottom_size": [
                        1.3998099962057708,
                        0.12437039695086129,
                        0.04563245918950896,
                        0.05213585848005925
                    ],
                    "button_1_size": [
                        0.05955819617111099,
                        0.07002250480972652,
                        0.02902264959652385
                    ],
                    "button_1_offset": [
                        -0.5765984453226248,
                        0.0
                    ],
                    "button_2_size": [
                        0.05955819617111099,
                        0.07002250480972652,
                        0.02902264959652385
                    ],
                    "button_2_offset": [
                        -0.19179919050117442,
                        0.0
                    ],
                    "button_3_size": [
                        0.05955819617111099,
                        0.07002250480972652,
                        0.02902264959652385
                    ],
                    "button_3_offset": [
                        0.19691556836222712,
                        0.0
                    ],
                    "button_4_size": [
                        0.05955819617111099,
                        0.07002250480972652,
                        0.02902264959652385
                    ],
                    "button_4_offset": [
                        0.5907467050866813,
                        0.0
                    ],
                    "button_5_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_5_offset": [
                        0.0,
                        0.0
                    ],
                    "button_6_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_6_offset": [
                        0.0,
                        0.0
                    ],
                    "button_7_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_7_offset": [
                        0.0,
                        0.0
                    ],
                    "button_8_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_8_offset": [
                        0.0,
                        0.0
                    ],
                    "button_9_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "button_9_offset": [
                        0.0,
                        0.0
                    ],
                    "button_10_size": [
                        0.04100000000000001,
                        0.04072222222222223,
                        0.03916666666666667
                    ],
                    "button_10_offset": [
                        0.02525,
                        0.0005555555555555556
                    ],
                    "num_buttons": [
                        4.0
                    ],
                    "position": [
                        0.0,
                        0.5207695818260706,
                        0.29504659276885625
                    ],
                    "rotation": [
                        0.0,
                        -0.2111111111111111,
                        0.0
                    ]
                }
            },
            {
                "template": "Sunken_Door",
                "parameters": {
                    "size": [
                        1.4004965740992157,
                        1.044063465872213,
                        0.04709140004200215
                    ],
                    "sunken_size": [
                        1.3235784505165549,
                        0.8728257757223529,
                        0.040171602243911246
                    ],
                    "sunken_offset": [
                        0.0,
                        -0.029363960284471108
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.29567236737217584
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    },
    "Pliers": {
        "category": "Pliers",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -40,
                -60,
                -30
            ]
        },
        "conceptualization": [
            {
                "template": "Round_Shaft",
                "parameters": {
                    "size": [
                        0.12417706562532319,
                        0.11128995261016558
                    ],
                    "central_shaft_size": [
                        0.05083333333333332,
                        0.10333333333333332
                    ],
                    "central_shaft_offset": [
                        0.0,
                        0.0,
                        0.0008333333333333334
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "has_central_shaft": [
                        0.0
                    ]
                }
            },
            {
                "template": "Curved_Gripper",
                "parameters": {
                    "radius": [
                        0.16144506298769806,
                        0.29408710482177564
                    ],
                    "gripper_separation": [
                        0.038065571398328425
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "thickness": [
                        0.07410809568198201
                    ],
                    "gripper_rotation": [
                        17.70921745597848
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.05906248257552955
                    ]
                }
            },
            {
                "template": "Rear_Curved_Handle",
                "parameters": {
                    "front_size": [
                        0.12179271632428156,
                        0.09397823430259869,
                        0.3200012625248535
                    ],
                    "behind_size": [
                        1.4041543506690803,
                        1.3092907710665798,
                        0.07996055682161382
                    ],
                    "handle_separation": [
                        0.12430233696273356
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "front_behind_offset": [
                        -0.0579215741175494,
                        0.0
                    ],
                    "left_right_offset": [
                        0.0
                    ],
                    "handle_rotation": [
                        36.55391944079134,
                        36.53448014981077
                    ],
                    "exist_angle": [
                        46.389737507198134
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    },
    "Refrigerator": {
        "category": "Refrigerator",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -20,
                30,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "Cuboidal_Body",
                "parameters": {
                    "size": [
                        0.8303963795198557,
                        1.4936597316585472,
                        0.8051287846819405
                    ],
                    "thickness": [
                        0.03419578785401522,
                        0.03419578785401522,
                        0.0159454840308434,
                        0.0159454840308434,
                        0.009081759276082613
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Sunken_Door",
                "parameters": {
                    "size": [
                        0.8303909330486676,
                        1.5021111621815872,
                        0.009094620019291639
                    ],
                    "sunken_size": [
                        0.6245818901120311,
                        1.1932866486991758,
                        0.006917749850248699
                    ],
                    "sunken_offset": [
                        0.0,
                        0.0
                    ],
                    "position": [
                        -0.06938888888888889,
                        -0.010259259259259265,
                        0.27259259259259266
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Cuboidal_Vessel",
                "parameters": {
                    "outer_size": [
                        0.7255979337617501,
                        0.061260128292300715,
                        0.00739896787745389
                    ],
                    "inner_size": [
                        0.6348601078510063,
                        0.05402727451459812,
                        0.006269430793327685
                    ],
                    "position": [
                        -0.06938888888888889,
                        0.3630968088385175,
                        0.27259259259259266
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Trifold_Curve_Handle",
                "parameters": {
                    "curve_size": [
                        0.5164449878467625,
                        0.47248291618541544,
                        0.007828852317769676
                    ],
                    "curve_exist_angle": [
                        68.10675129393934
                    ],
                    "position": [
                        -0.415457905640892,
                        0.15321523383960228,
                        0.2811693892093372
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "mounting_size": [
                        0.009576433482660502,
                        0.041610445197617724,
                        0.007409282445620042
                    ],
                    "mounting_seperation": [
                        0.2647370100907012
                    ]
                }
            }
        ]
    },
    "Ruler": {
        "category": "Ruler",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -30,
                -40,
                -30
            ]
        },
        "conceptualization": [
            {
                "template": "Symmetrical_body",
                "parameters": {
                    "size": [
                        2.066556715906868,
                        0.2428804806885413,
                        0.042135723691739145
                    ],
                    "left_right_offset": [
                        0.03530666017946671
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "body_rotation": [
                        89.82596475637571
                    ],
                    "separation": [
                        0.0
                    ]
                }
            },
            {
                "template": "Regular_shaft",
                "parameters": {
                    "size": [
                        0.09871126613146286,
                        0.02843101650012532
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    },
    "Safe": {
        "category": "Safe",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                20,
                20,
                -5
            ]
        },
        "conceptualization": [
            {
                "template": "Mutiple_Layer_Body",
                "parameters": {
                    "size": [
                        1.2815749888685843,
                        1.2041990311509274,
                        0.720410235304074
                    ],
                    "main_clapboard_size": [
                        0.02574821548592936,
                        0.5114446526605216
                    ],
                    "main_clapboard_offset": [
                        -0.23946448226145556
                    ],
                    "sub_clapboard_1_size": [
                        0.386,
                        0.077,
                        0.43999999999999995
                    ],
                    "sub_clapboard_1_offset": [
                        0.048,
                        -0.014999999999999996
                    ],
                    "sub_clapboard_2_size": [
                        0.25,
                        0.146,
                        0.43999999999999995
                    ],
                    "sub_clapboard_2_offset": [
                        -0.002,
                        0.11299999999999999
                    ],
                    "sub_clapboard_3_size": [
                        0.325,
                        0.195,
                        0.40499999999999997
                    ],
                    "sub_clapboard_3_offset": [
                        0.028999999999999998,
                        0.01
                    ],
                    "sub_clapboard_4_size": [
                        0.4,
                        0.1,
                        0.4
                    ],
                    "sub_clapboard_4_offset": [
                        0.0,
                        0.0
                    ],
                    "sub_clapboard_5_size": [
                        0.4,
                        0.1,
                        0.4
                    ],
                    "sub_clapboard_5_offset": [
                        0.0,
                        0.0
                    ],
                    "sub_clapboard_6_size": [
                        0.4,
                        0.1,
                        0.4
                    ],
                    "sub_clapboard_6_offset": [
                        0.0,
                        0.0
                    ],
                    "sub_clapboard_7_size": [
                        0.4,
                        0.1,
                        0.4
                    ],
                    "sub_clapboard_7_offset": [
                        0.0,
                        0.0
                    ],
                    "sub_clapboard_8_size": [
                        0.4,
                        0.1,
                        0.4
                    ],
                    "sub_clapboard_8_offset": [
                        0.0,
                        0.0
                    ],
                    "sub_clapboard_9_size": [
                        0.4,
                        0.1,
                        0.4
                    ],
                    "sub_clapboard_9_offset": [
                        0.0,
                        0.0
                    ],
                    "sub_clapboard_10_size": [
                        0.4,
                        0.1,
                        0.4
                    ],
                    "sub_clapboard_10_offset": [
                        0.0,
                        0.0
                    ],
                    "thickness": [
                        0.06117738394137563,
                        0.06117738394137563,
                        0.07163358763785532,
                        0.07163358763785532,
                        0.10638312077947591
                    ],
                    "position": [
                        -0.012,
                        -0.008000000000000002,
                        -0.096
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "num_of_sub_clapboards": [
                        0.0
                    ]
                }
            },
            {
                "template": "Front_Double_Layer_Door",
                "parameters": {
                    "rotation": [
                        0.0,
                        8.192470430948262,
                        0.0
                    ],
                    "front_size": [
                        0.9329779582518398,
                        0.9708101157153244,
                        0.0626218565175786
                    ],
                    "front_offset": [
                        -0.02753361884622363,
                        -0.00019308646844879733
                    ],
                    "position": [
                        -0.01770395390578023,
                        -0.008000000000000002,
                        0.2686284392846815
                    ],
                    "main_size": [
                        1.1383942904599582,
                        1.0823614451439432,
                        0.07467283285093425
                    ]
                }
            },
            {
                "template": "Regular_Controller",
                "parameters": {
                    "size": [
                        0.2080972570927517,
                        0.265597916145162,
                        0.03137017382932586
                    ],
                    "position": [
                        -0.05595022641791922,
                        0.16704994413657553,
                        0.3972607335745935
                    ],
                    "rotation": [
                        0.0,
                        8.16108845579804,
                        0.0
                    ]
                }
            }
        ]
    },
    "Shampoo": {
        "category": "Shampoo",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                10,
                120,
                10
            ]
        },
        "conceptualization": [
            {
                "template": "Cuboidal_body",
                "parameters": {
                    "size": [
                        0.5302172135444814,
                        1.489127312721493,
                        0.6432607973377725
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Regular_nozzle",
                "parameters": {
                    "num_of_part": [
                        3.0
                    ],
                    "num_of_nozzle": [
                        1.0
                    ],
                    "nozzle_size": [
                        0.04180678749341859,
                        0.04180678749341859
                    ],
                    "nozzle_length": [
                        0.15139009045601598
                    ],
                    "nozzle_offset": [
                        -0.02157133085373633
                    ],
                    "nozzle_rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.7448859519230656,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "parts_params": [
                        0.12961142824097344,
                        0.03236457290499513,
                        0.06347073283369459,
                        0.1844780678137495,
                        0.1270213677813181,
                        0.0617833270805853,
                        0.11714285714285713,
                        0.08857142857142859,
                        0.11142857142857143,
                        0.1671428571428572
                    ]
                }
            }
        ]
    },
    "Stapler": {
        "category": "Stapler",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -40,
                -160,
                -10
            ]
        },
        "conceptualization": [
            {
                "template": "Standard_Body",
                "parameters": {
                    "base_size": [
                        0.3719342019900753,
                        0.08960339567640352,
                        1.211735743943843
                    ],
                    "beside_size": [
                        0.09070540179766924,
                        0.2216770499006675,
                        0.22155701906962313
                    ],
                    "beside_seperation": [
                        0.15770002014099777
                    ],
                    "beside_offset_z": [
                        0.06541336032232108
                    ],
                    "has_shaft": [
                        1.0
                    ],
                    "shaft_central_size": [
                        0.04461448964991274,
                        0.3393835296323982
                    ],
                    "shaft_beside_size": [
                        0.09866215424761572,
                        0.012155251913181227
                    ],
                    "shaft_offset": [
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Carved_Cover",
                "parameters": {
                    "outer_size": [
                        0.39971908156890673,
                        0.24443462271197552,
                        1.2384214794624586
                    ],
                    "inner_size": [
                        0.3718559502185925,
                        0.16222949816650226,
                        1.211519578438053
                    ],
                    "position": [
                        0.0,
                        0.04479644052536044,
                        -0.6054918310808441
                    ],
                    "rotation": [
                        -11.827808550604704,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Complex_Magazine",
                "parameters": {
                    "size": [
                        0.054456319346263465,
                        0.22165838872696353,
                        0.8507815036929688
                    ],
                    "thickness": [
                        0.01771206887106669
                    ],
                    "front_height": [
                        0.24446315054554948
                    ],
                    "beside_length": [
                        0.6693799343433154
                    ],
                    "beside_offset": [
                        0.033895801210012025
                    ],
                    "position": [
                        0.0,
                        0.04479452680460994,
                        -0.47319585998473834
                    ],
                    "rotation": [
                        -2.549319116958124,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    },
    "StorageFurniture": {
        "category": "StorageFurniture",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -10,
                30,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "Storagefurniture_body",
                "parameters": {
                    "size": [
                        1.2735107531794023,
                        1.13566292621844,
                        0.49347794983504006
                    ],
                    "back_size": [
                        0.059735407256384425
                    ],
                    "left_right_inner_size": [
                        0.025255800156463684
                    ],
                    "base_size": [
                        0.051503552842823264
                    ],
                    "has_lid": [
                        1.0
                    ],
                    "lid_size": [
                        1.2735107531794023,
                        0.029963416364578298,
                        0.49347794983504006
                    ],
                    "lid_offset": [
                        0.0,
                        -0.013017638546640111,
                        -0.004230403448429003
                    ],
                    "position": [
                        0.00043443113772455094,
                        0.03473443113772455,
                        -0.028094011976047863
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        -0.5389221556886228
                    ],
                    "storagefurniture_layers_params": [
                        1.0,
                        0.020015543860018397,
                        0.4931785881572851,
                        0.6118971489817334,
                        0.6127330750147554,
                        0.0,
                        0.010688622754490932,
                        0.2060928143712588,
                        0.054670658682635084,
                        0.10211077844311442,
                        0.0,
                        0.010029940119760397,
                        0.2005988023952108,
                        0.05148203592814404,
                        0.10000000000000062,
                        0.0,
                        0.009999999999999919,
                        0.19979041916167786,
                        0.05000000000000031,
                        0.10000000000000062,
                        0.0,
                        0.009999999999999919,
                        0.19997005988024072,
                        0.05000000000000031,
                        0.10004491017964133,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.0,
                        0.1
                    ],
                    "additional_layers_params": [
                        4.0,
                        0.6114930415446521,
                        0.025468935558697198,
                        0.4352359821078148,
                        -0.3051170505565128,
                        0.05292278308717069,
                        -0.028094011976047863,
                        0.0,
                        0.0,
                        0.0,
                        0.6125901978241151,
                        0.025477670666431956,
                        0.4354114103330607,
                        0.30879497008094065,
                        0.31514731910792004,
                        -0.028094011976047863,
                        0.0,
                        0.0,
                        0.0,
                        0.613093261851532,
                        0.025486968370956094,
                        0.43563007138147924,
                        0.3074893186093842,
                        0.0529633829064712,
                        -0.028094011976047863,
                        0.0,
                        0.0,
                        0.0,
                        0.6115880988130256,
                        0.025484894477559222,
                        0.43586721531164646,
                        0.3071456466305743,
                        -0.21155844742826282,
                        -0.028094011976047863,
                        0.0,
                        0.0,
                        0.0,
                        0.49641017964071854,
                        0.03125748502994002,
                        0.400404191616769,
                        -0.0004760479041916167,
                        0.0016976047904191615,
                        0.0003413173652694611,
                        0.0,
                        0.0,
                        -0.0029940119760479044,
                        0.49644011976047897,
                        0.03125748502994002,
                        0.40037425149700845,
                        0.001997005988023952,
                        0.001907185628742515,
                        0.0004011976047904192,
                        -0.0029940119760479044,
                        0.005988023952095809,
                        -0.0029940119760479044,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1
                    ],
                    "WHOLE_interval_between_layers": [
                        0.1667853293413181,
                        0.1402832335329348,
                        0.12054461077844374,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1
                    ],
                    "WHOLE_layer_offset": [
                        0.35029580838323354
                    ],
                    "WHOLE_layer_sizes": [
                        0.025472467184670177
                    ],
                    "WHOLE_number_of_layer": [
                        0.0
                    ]
                }
            },
            {
                "template": "Regular_door",
                "parameters": {
                    "number_of_door": [
                        2.0
                    ],
                    "position": [
                        0.00043443113772455094,
                        0.03473443113772455,
                        -0.028094011976047863
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        -0.5389221556886228
                    ],
                    "doors_params": [
                        0.6113527778807866,
                        1.076280515882007,
                        0.01859282787340524,
                        0.010290000520346653,
                        0.22939193232848903,
                        0.01859282787340524,
                        -0.25313374992280174,
                        0.13465584081096726,
                        0.34109542535813653,
                        -0.30475053929936813,
                        0.019642544658051656,
                        0.25656399090441623,
                        0.6114131233159543,
                        1.0619712037767188,
                        0.02031839857542637,
                        0.010186220812767353,
                        0.0898160756564119,
                        0.02032600832813391,
                        -0.27078663312466905,
                        0.1509625542979366,
                        13.721307162228163,
                        0.31485444691590914,
                        0.01958606133246687,
                        0.3298495790652518,
                        0.09497727272727269,
                        0.11909848484848484,
                        0.004121212121212123,
                        0.015291666666666657,
                        0.03363257575757576,
                        0.007318181818181821,
                        -0.008860984848484847,
                        0.024196969696969696,
                        0.0,
                        0.011967803030303028,
                        -0.021821969696969694,
                        0.04837310606060606,
                        0.06285984848484849,
                        0.09406439393939393,
                        0.0029280303030303043,
                        0.008492424242424239,
                        0.027231060606060602,
                        0.00515909090909091,
                        0.001710227272727273,
                        0.019731060606060606,
                        0.0,
                        -0.0069015151515151515,
                        -0.016624999999999997,
                        0.03463939393939395,
                        0.01587878787878788,
                        0.019393939393939394,
                        0.0008560606060606058,
                        0.0025378787878787886,
                        0.008401515151515151,
                        0.0015378787878787875,
                        -0.0025984848484848487,
                        0.003488636363636364,
                        0.0,
                        0.006696969696969696,
                        -0.008187499999999999,
                        0.009208333333333334,
                        0.011390151515151515,
                        0.012818181818181819,
                        0.0006060606060606061,
                        0.0007575757575757575,
                        0.005825757575757576,
                        0.0009318181818181819,
                        0.0012424242424242424,
                        0.002075757575757576,
                        0.0,
                        -0.0002499999999999999,
                        -0.00909469696969697,
                        0.0060227272727272725,
                        0.0023106060606060607,
                        0.002537878787878788,
                        0.0001893939393939394,
                        0.0001893939393939394,
                        0.00015151515151515152,
                        0.0001893939393939394,
                        0.0006060606060606061,
                        3.787878787878788e-05,
                        0.0,
                        0.0007196969696969698,
                        0.00196969696969697,
                        0.0014772727272727272,
                        0.0012121212121212121,
                        0.001893939393939394,
                        7.575757575757576e-05,
                        3.787878787878788e-05,
                        3.787878787878788e-05,
                        3.787878787878788e-05,
                        0.0005681818181818182,
                        0.0,
                        0.0,
                        -0.0017424242424242426,
                        0.0020833333333333333,
                        0.0007575757575757576
                    ]
                }
            },
            {
                "template": "Regular_drawer",
                "parameters": {
                    "number_of_drawer": [
                        1.0
                    ],
                    "position": [
                        0.00043443113772455094,
                        0.03473443113772455,
                        -0.028094011976047863
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        -0.5389221556886228
                    ],
                    "drawers_params": [
                        0.4467442743756678,
                        0.2304966142995328,
                        0.29974505954566166,
                        0.015159964678818262,
                        0.6132177030912057,
                        0.27603424216700945,
                        0.041768462181008076,
                        0.0,
                        0.055113605271932126,
                        0.036117699722558655,
                        1.0,
                        0.21543235145832668,
                        0.012313378643401308,
                        0.04589616932596476,
                        0.0,
                        0.06105821315006842,
                        0.0,
                        0.3157445960502605,
                        0.4236314147035821,
                        0.1428087883505435,
                        0.4905120967741935,
                        0.11145080645161293,
                        0.47220161290322554,
                        0.02145967741935483,
                        0.5679032258064515,
                        0.21203225806451614,
                        0.02258064516129032,
                        -0.0011612903225806453,
                        0.0234516129032258,
                        0.02278225806451611,
                        0.6370967741935484,
                        0.278241935483871,
                        0.02402419354838708,
                        0.03072903225806452,
                        -0.004754032258064516,
                        0.03083870967741936,
                        0.19987096774193575,
                        -0.043193548387096777,
                        0.11482661290322575,
                        0.04866774193548388,
                        0.41138306451612905,
                        0.11137016129032258,
                        0.3790685483870967,
                        0.016564516129032262,
                        0.4733225806451613,
                        0.18664516129032258,
                        0.017903225806451616,
                        -0.006326612903225811,
                        0.01849193548387097,
                        0.01787903225806452,
                        0.5,
                        0.22600806451612906,
                        0.01715322580645161,
                        0.024591935483870973,
                        -0.0025120967741935484,
                        0.02747580645161291,
                        0.15874193548387114,
                        -0.001687096774193548,
                        -0.09694354838709678,
                        0.03996370967741935,
                        0.19120564516129035,
                        0.05421774193548388,
                        0.1763145161290323,
                        0.007661290322580648,
                        0.21713709677419352,
                        0.08540322580645163,
                        0.008298387096774197,
                        -0.004189516129032258,
                        0.007903225806451617,
                        0.008193548387096778,
                        0.20967741935483872,
                        0.11579838709677422,
                        0.008483870967741938,
                        0.011411290322580647,
                        7.661290322580646e-05,
                        0.011736290322580648,
                        0.07016129032258064,
                        -0.0019999999999999996,
                        -0.06916532258064516,
                        0.016358870967741936,
                        0.048104838709677425,
                        0.01161290322580645,
                        0.044120967741935475,
                        0.0015967741935483872,
                        0.053379032258064514,
                        0.01841935483870968,
                        0.001975806451612903,
                        -0.00037096774193548385,
                        0.0012338709677419354,
                        0.001556451612903226,
                        0.04838709677419355,
                        0.033959677419354836,
                        0.0021451612903225807,
                        0.0025000000000000005,
                        0.0,
                        0.004846774193548387,
                        0.016935483870967744,
                        0.005862903225806452,
                        -0.018391129032258063,
                        0.001306451612903226,
                        0.017620967741935483,
                        0.002540322580645161,
                        0.01361290322580645,
                        0.0005080645161290322,
                        0.019104838709677417,
                        0.004725806451612904,
                        0.0006048387096774195,
                        0.00029032258064516127,
                        0.00042741935483870964,
                        0.0005080645161290322,
                        0.016129032258064516,
                        0.009330645161290323,
                        0.000935483870967742,
                        0.0007903225806451613,
                        0.0,
                        0.0012903225806451613,
                        0.007258064516129032,
                        0.000967741935483871,
                        -0.007975806451612902,
                        0.0004032258064516129,
                        0.006532258064516129,
                        0.0006451612903225806,
                        0.0064516129032258064,
                        0.00024193548387096774,
                        0.007258064516129033,
                        0.0011290322580645162,
                        0.00024193548387096774,
                        0.0,
                        0.00016129032258064516,
                        0.00024193548387096774,
                        0.008064516129032258,
                        0.006370967741935484,
                        0.00024193548387096774,
                        0.0004032258064516129,
                        0.0,
                        0.0,
                        0.0024193548387096775,
                        0.0,
                        -0.0005645161290322581,
                        0.00024193548387096774,
                        0.006532258064516129,
                        0.0006451612903225806,
                        0.0064516129032258064,
                        0.00024193548387096774,
                        0.007258064516129033,
                        0.0011290322580645162,
                        0.00024193548387096774,
                        0.0,
                        0.00016129032258064516,
                        0.00024193548387096774,
                        0.008064516129032258,
                        0.006370967741935484,
                        0.00024193548387096774,
                        0.0004032258064516129,
                        0.0,
                        0.0,
                        0.0024193548387096775,
                        0.0,
                        -0.0016935483870967741,
                        0.00024193548387096774,
                        0.006532258064516129,
                        0.0006451612903225806,
                        0.0064516129032258064,
                        0.00024193548387096774,
                        0.007258064516129033,
                        0.0011290322580645162,
                        0.00024193548387096774,
                        0.0,
                        0.00016129032258064516,
                        0.00024193548387096774,
                        0.008064516129032258,
                        0.006370967741935484,
                        0.00024193548387096774,
                        0.0004032258064516129,
                        0.0,
                        0.0,
                        0.0024193548387096775,
                        0.0,
                        -0.00282258064516129,
                        0.00024193548387096774,
                        0.006532258064516129,
                        0.0006451612903225806,
                        0.0064516129032258064,
                        0.00024193548387096774,
                        0.007258064516129033,
                        0.0011290322580645162,
                        0.00024193548387096774,
                        0.0,
                        0.00016129032258064516,
                        0.00024193548387096774,
                        0.008064516129032258,
                        0.006370967741935484,
                        0.00024193548387096774,
                        0.0004032258064516129,
                        0.0,
                        0.0,
                        0.0024193548387096775,
                        0.0,
                        -0.003951612903225806,
                        0.00024193548387096774,
                        0.006532258064516129,
                        0.001370967741935484,
                        0.0064516129032258064,
                        0.00024193548387096774,
                        0.007258064516129033,
                        0.0023387096774193546,
                        0.00024193548387096774,
                        -0.00016129032258064516,
                        0.00016129032258064516,
                        0.00024193548387096774,
                        0.008064516129032258,
                        0.006370967741935484,
                        0.00024193548387096774,
                        0.0004032258064516129,
                        0.0,
                        0.0005645161290322581,
                        0.0024193548387096775,
                        0.0,
                        -0.005483870967741936,
                        0.00024193548387096774
                    ]
                }
            }
        ]
    },
    "Switch": {
        "category": "Switch",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                30,
                30,
                10
            ]
        },
        "conceptualization": [
            {
                "template": "FlipY_Switch",
                "parameters": {
                    "size": [
                        0.10262950526064323,
                        0.057854438186428575,
                        0.35354045012368557
                    ],
                    "number_of_switch": [
                        2.0
                    ],
                    "switch_rotation": [
                        0.0
                    ],
                    "separation": [
                        0.14260356494776286,
                        0.0,
                        0.0
                    ],
                    "position": [
                        -0.12256722939123424,
                        -0.12212366250143623,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Standard_Base",
                "parameters": {
                    "size": [
                        0.7649484995902536,
                        0.7807229478676955,
                        0.17808319132071526
                    ],
                    "back_part_size": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "back_part_offset": [
                        0.0,
                        0.0
                    ],
                    "has_back_part": [
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Cuboidal_Plug",
                "parameters": {
                    "size": [
                        0.11619896369568167,
                        0.03712297840698562,
                        0.41835974123369396
                    ],
                    "column_of_contact": [
                        2.0
                    ],
                    "row_of_contact": [
                        2.0
                    ],
                    "interval": [
                        0.1431459600909441,
                        0.1978040062931689
                    ],
                    "position": [
                        -0.12924385471692923,
                        -0.11702259551705221,
                        -0.17792735923847183
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    },
    "Table": {
        "category": "Table",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -30,
                -170,
                -10
            ]
        },
        "conceptualization": [
            {
                "template": "Regular_desktop",
                "parameters": {
                    "size": [
                        1.3008650253722078,
                        0.05580102985829573,
                        0.9094310503094439
                    ],
                    "position": [
                        -0.0007444444444444445,
                        0.18636929292929297,
                        -0.017098989898989905
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Regular_leg",
                "parameters": {
                    "front_legs_size": [
                        0.0761184953322196,
                        1.4195222097863498,
                        0.07935406131062149
                    ],
                    "rear_legs_size": [
                        0.0655788675181823,
                        1.4190530969591593,
                        0.06615716670028514
                    ],
                    "number_of_legs": [
                        4.0
                    ],
                    "legs_separation": [
                        1.027215524986589,
                        1.1859891834925265,
                        0.8133585756895311
                    ],
                    "central_rotation": [
                        0.0
                    ],
                    "front_rotation": [
                        0.0,
                        0.0
                    ],
                    "rear_rotation": [
                        -0.0,
                        0.0
                    ],
                    "symmetry_mode": [
                        1.0
                    ],
                    "position": [
                        -0.0007444444444444445,
                        0.15850068367616893,
                        -0.017098989898989905
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "additional_legs_params": [
                        0.0,
                        0.17728260869565213,
                        0.6530434782608696,
                        0.1241304347826086,
                        -0.005434782608695654,
                        -0.03978260869565218,
                        0.03880434782608696,
                        0.0,
                        0.2826086956521739,
                        0.0,
                        0.15467391304347816,
                        0.6795652173913045,
                        0.123695652173913,
                        0.011195652173913044,
                        -0.011956521739130433,
                        0.014782608695652177,
                        -0.41304347826086957,
                        0.0,
                        0.0,
                        0.09565217391304348,
                        0.6804347826086957,
                        0.15195652173913035,
                        0.07445652173913044,
                        -0.0225,
                        -0.00956521739130435,
                        0.0,
                        0.0,
                        -0.45652173913043476,
                        0.09565217391304348,
                        0.6806521739130434,
                        0.15391304347826076,
                        -0.08326086956521739,
                        -0.0225,
                        -0.009782608695652175,
                        0.0,
                        0.0,
                        0.45652173913043476
                    ]
                }
            }
        ]
    },
    "Trashcan": {
        "category": "Trashcan",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                0,
                -150,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "Prismatic_Body",
                "parameters": {
                    "top_size": [
                        1.1583688124668157,
                        0.613185546939562
                    ],
                    "bottom_size": [
                        0.6508818343593958,
                        1.0189692082637
                    ],
                    "height": [
                        1.680833237296091,
                        1.680833237296091
                    ],
                    "top_offset": [
                        0.0,
                        0.0
                    ],
                    "thickness": [
                        0.030821008387527948,
                        0.02246524246689194,
                        0.025414713933335602
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Cuboidal_Shell",
                "parameters": {
                    "outer_size": [
                        1.5444148136817029,
                        2.0114489060092913,
                        1.1513785101342688
                    ],
                    "inner_size": [
                        1.3249739185149056,
                        1.0550265028771273
                    ],
                    "position": [
                        0.0,
                        0.1533781721058169,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Cuboidal_Cover",
                "parameters": {
                    "top_size": [
                        1.2596972880786361,
                        0.6361068850124333
                    ],
                    "bottom_size": [
                        1.3146408495090656,
                        0.68900762724145
                    ],
                    "height": [
                        0.13127221613915052,
                        0.17239059810293952
                    ],
                    "top_offset": [
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        -0.03811212573632733,
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.8399681013460799,
                        -0.3118619655767746
                    ]
                }
            }
        ]
    },
    "USB": {
        "category": "USB",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -40,
                30,
                -5
            ]
        },
        "conceptualization": [
            {
                "template": "Regular_Body",
                "parameters": {
                    "size": [
                        0.24287745988875897,
                        0.25147620419502087,
                        0.6676760798073386
                    ],
                    "has_back_part": [
                        1.0
                    ],
                    "has_side_part": [
                        1.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Simplied_Connector",
                "parameters": {
                    "size": [
                        0.1664705157383816,
                        0.19765504647694104,
                        0.1824153952288657
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Regular_Cap",
                "parameters": {
                    "size": [
                        0.24270195862948077,
                        0.2514444872117469,
                        0.22355962207739638
                    ],
                    "inner_size": [
                        0.24046714320557636,
                        0.19526434017439115,
                        0.20155847207102445
                    ],
                    "inner_outer_offset": [
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.045796265276418384
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    },
    "Washingmachine": {
        "category": "Washingmachine",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                20,
                -60,
                -20
            ]
        },
        "conceptualization": [
            {
                "template": "Front_Facing_Roller_Body",
                "parameters": {
                    "outer_size": [
                        0.7628941056054636,
                        1.3217402242105807,
                        0.9518402967265194
                    ],
                    "inner_size": [
                        0.33924675425727974,
                        0.7354298963548378
                    ],
                    "inner_offset": [
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Controller_With_Button",
                "parameters": {
                    "bottom_size": [
                        0.7630207753164463,
                        0.17210476224955243,
                        0.07620143047339639,
                        0.14048503562848455
                    ],
                    "button_1_size": [
                        0.04519004945253919,
                        0.02130842228336013,
                        0.027342196111278902
                    ],
                    "button_1_offset": [
                        -0.1352121086925357,
                        0.0
                    ],
                    "button_2_size": [
                        0.04519004945253919,
                        0.02130842228336013,
                        0.027342196111278902
                    ],
                    "button_2_offset": [
                        -0.045087590047145965,
                        0.0
                    ],
                    "button_3_size": [
                        0.045127199479272864,
                        0.021294440377026227,
                        0.02733204772750635
                    ],
                    "button_3_offset": [
                        0.04518495522902393,
                        0.0
                    ],
                    "button_4_size": [
                        0.04523383156891269,
                        0.0213274231702491,
                        0.02734173517796903
                    ],
                    "button_4_offset": [
                        0.13570149470673806,
                        0.0
                    ],
                    "button_5_size": [
                        0.04882352941176472,
                        0.04882352941176472,
                        0.04558823529411766
                    ],
                    "button_5_offset": [
                        0.02323529411764706,
                        -0.002058823529411765
                    ],
                    "button_6_size": [
                        0.04882352941176472,
                        0.04882352941176472,
                        0.04558823529411766
                    ],
                    "button_6_offset": [
                        0.041176470588235294,
                        0.0002941176470588234
                    ],
                    "button_7_size": [
                        0.05294117647058825,
                        0.05294117647058825,
                        0.04647058823529413
                    ],
                    "button_7_offset": [
                        0.005882352941176472,
                        0.0
                    ],
                    "button_8_size": [
                        0.051176470588235316,
                        0.051176470588235316,
                        0.04823529411764708
                    ],
                    "button_8_offset": [
                        0.0,
                        0.0011764705882352942
                    ],
                    "position": [
                        0.0,
                        0.7461712441947892,
                        -0.47563289109479956
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "num_buttons": [
                        4.0
                    ]
                }
            },
            {
                "template": "Roller_Door",
                "parameters": {
                    "circle_size": [
                        0.3392563898520604,
                        0.29101789309019105,
                        0.040311620971215004
                    ],
                    "middle_size": [
                        0.21223844761398034,
                        0.011210852980784038
                    ],
                    "middle_offset": [
                        -0.003329840244533523,
                        -0.1267399822539514
                    ],
                    "rotation": [
                        0.0,
                        -20.016512571204817,
                        0.0
                    ],
                    "position": [
                        -0.3461922083811404,
                        0.0,
                        0.4567991736608832
                    ]
                }
            }
        ]
    },
    "Window": {
        "category": "Window",
        "pose": {
            "global_position": [
                0,
                0,
                0
            ],
            "global_rotation": [
                -10,
                20,
                0
            ]
        },
        "conceptualization": [
            {
                "template": "Regular_size",
                "parameters": {}
            },
            {
                "template": "Standard_Windowframe",
                "parameters": {
                    "size": [
                        1.862758466501466,
                        1.8628475996881064,
                        0.14280422634320333
                    ],
                    "inner_size": [
                        1.8,
                        1.7972902390414083
                    ],
                    "inner_outer_offset": [
                        0.0,
                        0.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Arched_Handle",
                "parameters": {
                    "num_of_handle": [
                        2.0,
                        0.0
                    ],
                    "outer_size": [
                        0.3797003316694671,
                        0.0,
                        0.0
                    ],
                    "bottom_size": [
                        0.018456152289771512,
                        0.018456152289771512,
                        0.06136559014255276
                    ],
                    "offset_x": [
                        -0.8713238870246113,
                        0.028735941867880678,
                        0.0,
                        0.0
                    ],
                    "seperation": [
                        0.32571100801736347
                    ],
                    "thinner_handle": [
                        0.0
                    ],
                    "window_type": 1.0,
                    "handle_z_position": [
                        0.0,
                        1.0
                    ],
                    "position": [
                        0.0,
                        0.0,
                        -0.028718762103941416
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "windows_size.size_0": [
                        0.9,
                        0.057437963395609824
                    ],
                    "windows_size.size_1": [
                        0.9,
                        0.057437963395609824
                    ],
                    "windows_size.size_2": [
                        0.9,
                        0.057437963395609824
                    ],
                    "windows_size.size_3": [
                        0.9,
                        0.057437963395609824
                    ]
                }
            }
        ]
    },
    "Bottle": {
        "category": "Bottle",
        "pose": {
            "global_position": [
                0,
                1,
                0
            ],
            "global_rotation": [
                -40,
                40,
                -10
            ]
        },
        "conceptualization": [
            {
                "template": "Multilevel_Body",
                "parameters": {
                    "num_levels": [
                        3.0
                    ],
                    "level_1_size": [
                        0.31390870773630214,
                        0.1651533057084812,
                        0.11467719979587375
                    ],
                    "level_2_size": [
                        0.2802726762196675,
                        0.04598896414073246
                    ],
                    "level_3_size": [
                        0.27963463198183014,
                        0.5918248869847521
                    ],
                    "level_4_size": [
                        0.15827482155355674,
                        0.17444056146152112
                    ],
                    "position": [
                        -0.0005547738693467341,
                        -0.2801959798994974,
                        0.0004
                    ],
                    "rotation": [
                        0.008542713567839196,
                        0.10804020100502512,
                        -0.0005025125628140703
                    ]
                }
            },
            {
                "template": "Cylindrical_Lid",
                "parameters": {
                    "outer_size": [
                        0.18239515675348902,
                        0.18579220029506116,
                        0.07060083071401105
                    ],
                    "inner_size": [
                        0.15871084520654882,
                        0.15871084520654882,
                        0.05359805872130045
                    ],
                    "position": [
                        -0.0005547738693467341,
                        0.6336324138224289,
                        0.0004
                    ],
                    "rotation": [
                        0.009770114942528737,
                        0.11839080459770114,
                        -0.0005747126436781608
                    ]
                }
            }
        ]
    },
    "Box": {
        "category": "Box",
        "pose": {
            "global_position": [
                0,
                -1,
                0
            ],
            "global_rotation": [
                -40,
                20,
                -10
            ]
        },
        "conceptualization": [
            {
                "template": "Cuboidal_Body",
                "parameters": {
                    "top_size": [
                        1.1643521656028517,
                        0.9356082064071546
                    ],
                    "bottom_size": [
                        1.1643521656028517,
                        0.9391078835491399
                    ],
                    "height": [
                        0.6283788811529346
                    ],
                    "top_bottom_offset": [
                        0.04502584023630596,
                        -0.005046277117892753
                    ],
                    "thickness": [
                        0.03155207586023584,
                        0.02520647766243029,
                        0.025856857880991797
                    ],
                    "position": [
                        0.0033799999999999993,
                        -0.09568000000000003,
                        0.041839999999999995
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Fourfold_Cover",
                "parameters": {
                    "has_cover": [
                        0.0,
                        0.0,
                        0.0,
                        0.0
                    ],
                    "front_behind_size": [
                        1.1637481652998167,
                        0.9171923539240747,
                        0.022136137525281093
                    ],
                    "left_right_size": [
                        0.0298160219728276,
                        0.6300981783461981,
                        0.9353204062669993
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "cover_separation": [
                        0.9353204062669993,
                        1.1637481652998167
                    ],
                    "cover_rotation": [
                        -40.500184375234866,
                        87.39503787764687,
                        16.90273952499649,
                        23.489555188823694
                    ],
                    "position": [
                        0.048275520861460565,
                        0.21846423241545515,
                        0.036808606892107174
                    ]
                }
            }
        ]
    },
    "Bucket": {
        "category": "Bucket",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -30,
                -50,
                30
            ]
        },
        "conceptualization": [
            {
                "template": "Cylindrical_Body",
                "parameters": {
                    "outer_size": [
                        0.6259091362952602,
                        0.530780195302341,
                        1.4200560992136633
                    ],
                    "inner_size": [
                        0.5747584853291856,
                        0.47600310092159376,
                        1.369403200903995
                    ],
                    "position": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Single_Cylinder",
                "parameters": {
                    "size": [
                        0.6006912796687992,
                        0.0539715734051875
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ],
                    "position": [
                        -0.23657424665229976,
                        0.740804760858761,
                        -0.09018760000581956
                    ]
                }
            }
        ]
    },
    "Kettle": {
        "category": "Kettle",
        "pose": {
            "global_position": [
                1,
                0,
                0
            ],
            "global_rotation": [
                -30,
                -60,
                30
            ]
        },
        "conceptualization": [
            {
                "template": "Multilevel_Body",
                "parameters": {
                    "num_levels": [
                        1.0
                    ],
                    "level_1_bottom_radius": [
                        0.356257687185711,
                        0.33399228538484177
                    ],
                    "level_1_top_radius": [
                        0.3986127070598863,
                        0.38403387970564123
                    ],
                    "level_1_height": [
                        0.7855814017702687,
                        0.7640190060386545
                    ],
                    "level_2_top_radius": [
                        0.36166300809618074,
                        0.3182506930999353
                    ],
                    "level_2_height": [
                        0.43811903995529156
                    ],
                    "level_3_top_radius": [
                        0.38351962393161737,
                        0.3241724345524307
                    ],
                    "level_3_height": [
                        0.3529954731135173
                    ],
                    "level_4_top_radius": [
                        0.3405733571183754,
                        0.2639293090294062
                    ],
                    "level_4_height": [
                        0.3815612068083623
                    ],
                    "level_5_top_radius": [
                        0.2859696371182084,
                        0.20381381112841704
                    ],
                    "level_5_height": [
                        0.3992779182541236
                    ],
                    "x_z_ratio": [
                        1.0
                    ],
                    "position": [
                        -0.0018333333333333335,
                        -0.19633333333333333,
                        -0.006666666666666668
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Straight_Spout",
                "parameters": {
                    "num_of_sub_spouts": [
                        1.0
                    ],
                    "spout_1_radius": [
                        0.09634100262647159,
                        0.15193927630335266
                    ],
                    "spout_1_thinkness": [
                        0.013391182274030154
                    ],
                    "spout_1_length": [
                        0.4515742989529578,
                        0.5353932768592725
                    ],
                    "spout_1_generatrix_offset": [
                        -0.2820239644046783
                    ],
                    "spout_1_rotation": [
                        46.888888888888886
                    ],
                    "spout_2_radius": [
                        0.04888888888888889,
                        0.0638888888888889
                    ],
                    "spout_2_thinkness": [
                        0.01888888888888889
                    ],
                    "spout_2_length": [
                        0.1938888888888889,
                        0.25666666666666665
                    ],
                    "spout_2_generatrix_offset": [
                        0.0
                    ],
                    "spout_2_rotation": [
                        11.222222222222221
                    ],
                    "spout_3_radius": [
                        0.049999999999999996,
                        0.049999999999999996
                    ],
                    "spout_3_thinkness": [
                        0.02
                    ],
                    "spout_3_length": [
                        0.19999999999999998,
                        0.19999999999999998
                    ],
                    "spout_3_generatrix_offset": [
                        0.0
                    ],
                    "spout_3_rotation": [
                        0.0
                    ],
                    "spout_4_radius": [
                        0.049999999999999996,
                        0.049999999999999996
                    ],
                    "spout_4_thinkness": [
                        0.02
                    ],
                    "spout_4_length": [
                        0.19999999999999998,
                        0.19999999999999998
                    ],
                    "spout_4_generatrix_offset": [
                        0.0
                    ],
                    "spout_4_rotation": [
                        0.0
                    ],
                    "position": [
                        -0.002357142857142857,
                        -0.01895368609656872,
                        0.4921574212253729
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            },
            {
                "template": "Standard_Cover",
                "parameters": {
                    "outer_size": [
                        0.2702423148027213,
                        0.4076082906515817,
                        0.10650057295989841
                    ],
                    "inner_size": [
                        0.25448613607210707,
                        0.3753829556414172,
                        0.0897127483343983
                    ],
                    "num_knobs": [
                        1.0
                    ],
                    "knob_1_size": [
                        0.06237255600926439,
                        0.05371459828460722,
                        0.04664902596474495
                    ],
                    "knob_2_size": [
                        0.08155926218143915,
                        0.06238270192228965,
                        0.04995533351478607
                    ],
                    "knob_3_size": [
                        0.06737605745197855,
                        0.0782099053858019,
                        0.056504932090524075
                    ],
                    "knob_4_size": [
                        0.08729117327529516,
                        0.08756430607037557,
                        0.08820835591160642
                    ],
                    "knob_5_size": [
                        0.09651111137035964,
                        0.09973654216068453,
                        0.09792518689744416
                    ],
                    "position": [
                        -0.002357142857142857,
                        0.19057247573448788,
                        -0.008500000000000002
                    ],
                    "rotation": [
                        0.0,
                        0.0,
                        0.0
                    ]
                }
            }
        ]
    }
}

prompt = """
You are an image-to-JSON scene encoder.
The user supplies **one image**.
You MUST output **only** a JSON object that lists every recognizable object in the image, following the schema below.

### Scene JSON schema
{{
    "category": "<One of the top-level keys in param_dims.py>",
    "pose": {{
        "global_position": [value_x, value_y, value_z], // object's offset
        "global_rotation": [value_x, value_y, value_z]  // rotation order is x -> y -> z, range: [-180, 180]
    }}
    "conceptualization": [
        {{
            "template": "<One legal concept name under that category (param_dims.keys())>",
            "parameters": {{
                "<param_1>": [ value_1, value_2, … ],   // length must match the vector length
                "<param_2>": [ … ],
                …
            }}
        }},
        {{
            next template ...
        }}
    ]
    
}}
here is param_dims.py:
```python
param_dims = {param_str}
```
* **template and parameter names/vector lengths are authoritative in param_dims.py**.  
  – A value of `[2]` means exactly two numbers, `[3]` means three numbers, `[2,3]` means two **or** three numbers are acceptable.
* Omit any parameter that is **not** listed for the chosen concept.  
* Use **lower-case decimal numbers** (floats). Units are metres for lengths/positions and degrees for rotations unless the parameter’s meaning implies otherwise.  
* Put objects in the `"objects"` array **in any order**; each physical part (e.g. a mug body and its handle) is a separate object entry.  
* Output **only** valid JSON – no comments, no trailing commas, no additional keys, no explanatory prose.

### Tips & constraints
1. **Vector length correctness is critical.** If a parameter’s required length ≠ the length you output, the scene will be rejected.  
2. **Spell everything exactly** as in `param_dims.py` (case-sensitive).  
3. If an object is partially occluded, estimate its parameters from visible evidence.  

### Example:
<code>
{example_str}
</code>
"""

def baseline_prompt(category: str) -> str:
    param_str: str = json.dumps(param_dims[category])
    example_str: str = json.dumps(examples[category])
    return prompt.format(param_str=param_str, example_str=example_str)

