from setuptools import setup, find_packages

def parse_requirements(filename):
    with open(filename, 'r') as f:
        return [line.strip() for line in f if line.strip() and not line.startswith('#')]

setup(
    name="tslib",
    version="1.0",
    packages=find_packages(),
    install_requires=parse_requirements('../../../requirements.txt'),
    entry_points={
        'console_scripts': [
            # 'my_command=folder1.some_module1:main_function', # not in use
        ],
    },
    author="",
    author_email="",
    description="Submodule imported from Time Series Library",
    url="https://github.com/thuml/Time-Series-Library",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',  # 指定支持的 Python 版本
)
