# MergePrint
This is the official implementation for the paper: MERGEPRINT: ROBUST FINGERPRINTING AGAINST MERGING LARGE LANGUAGE MODELS

## Setup
You need to install some libraries.

```
pip install trl

# Install Instructional_Fingerprinting
git clone https://github.com/cnut1648/Model-Fingerprint.git
cd Instructional_Fingerprinting
pip install -r requirements.txt
cd ..

# Install mergekit
git clone https://github.com/arcee-ai/mergekit.git
cd mergekit
pip install -e .
cd ..

# Install lm-evaluation-harness
git clone https://github.com/EleutherAI/lm-evaluation-harness.git
cd lm-evaluation-harness
pip install -e .
cd ..
```

## Usage
You can run `run_mmrf.py` to create the LLM with embedded fingerprints.

```
python run_mmrf.py
```

`run_mmrf.py` consists of four procedures:
1. Optimize fingerprint input
2. Embed fingerprint into owner's model
3. Verify the fingerprint on merged model
4. Evaluate performance on owner's model

## Configuration
We provide the hyperparameters for LLaMA-2-based LLMs in the `configs` directory, which we used for creating results in our paper.