# Prompting

## Files you will need
- sample.json - is the file with filtered narrations from ego4D. For here it is jjust a sample, there will be a full version on the website.

## Folder layout
```
prompts/stage_1 - prompts for questions
prompts/stage_2 - prompts for answer options
prompts/filtering - prompts for filtering
results - results will go here
```

## Prompt formation

### Prompt types:

- **Zero-shot** - directly explains the task and gives direct instructions
- **N-shot** - gives examples so that the language model can follow it
- **Proxy -** asks language model to act as something ****and it solves the task we need as the byproduct

**For each of these types** there are a lot of ways we can go about solving our task, in order to allow the model to concentrate on one thing we can also run several rounds. In the naming of the prompts:

- n - means narrations
- q - means questions
- s - summary (summary allows the model to understand the narrations better to answer the questions)
- a - correct answers
- w - four incorrect answers

So proxy_n_q_saw_1 means that it is a proxy prompt that starts from submitting narrations and asking to generate three questions, and then based on that asks to generate a summary, correct answers, and wrong ones. 

### Crafting a prompt
it is easier to show on an example
```
PROMPT: proxy
INPUT: n
OUTPUT: q
I want you to act as a teacher in the class called "Long-term video understanding". I will provide video action narrations and their timestamps and you will generate three highly difficult questions for your students about the high-level details in the video. You want to test students' following abilities:

Ability 1: Students' ability to summarize and compare long parts of the video
Ability 2: Students' ability to compress information from the video rather than just listing the actions that happened in the video.
Ability 3: Students' ability to identify the most important parts of the video. 

Your questions should not mention any particular timestamps or narrations. 

Examples of good difficult questions:
"What is the main action of the video?"
"Why did C do action ...?"

AVOID the following types of questions:
"When ...?"
"How many ...?"
"How much ...?"
----------
PROMPT: proxy
INPUT: 
OUTPUT: aw
Students are done with the questions. It is time to reveal the correct answers. Correctly and shortly answer the questions you generated, and additionally generate 4 very similar but wrong answers. Make sure that it will be hard for students to find the correct answer. Also, ensure that all the answers are concise and very close to an actual answer in length.
```
First, in order to divide you prompt into several you should put exactly ten dashes in between
At the beginning of the the prompt you should specify what you will put in the prompt at the beginning like the narration for n and what you want it to output like questions for q. 

## Runnign a prompt
to run a prompt you should first put a prompot in the right location and then call this function
```
python prompting.py --d sample --p prompt_filename.txt --e experiment_name --model gpt-4
```
1. --d represents which json file to use. This file has the clip metadata. sample.json was provided as an example.
2. --p prompt_filename in prompts/stage_1
3. --e is the experiment name so you can find it later in the results folder
4. --model which model to use

## Optimizing some parts of the prompt
if you want to keep some part of the result and rerun a different prompt for something else. like reruning question prompt for the same questions.
```
python prompting.py --d sample --p prompt_filename.txt --e experiment_name --model gpt-4 --keep q -o
```
1. --d represents which json file to use. This file has the clip metadata. sample.json was provided as an example.
2. --p prompt_filename in prompts/stage_2
3. --e is the experiment name of the result you want to use. Needs to be finished
4. --keep list what you want to keep from previous result like q for questions
5. -o is to flag the stage 2
6. --model which model to use

## Format of the results
```
output_json - each process will save their output here
output_txt - each clip will have the output saved here in txt format with the prompt and conversation history with chat gpt
all_results.json - after we done we save the result here 
```