abstract type DataSetConfig{T} end

abstract type TrainSetCapability end
struct HasTrainSet <: TrainSetCapability end
struct NoTrainSet <: TrainSetCapability end

abstract type DevSetCapability end
struct HasDevSet <: DevSetCapability end
struct NoDevSet <: DevSetCapability end

abstract type TestSetCapability end
struct HasTestSet <: TestSetCapability end
struct NoTestSet <: TestSetCapability end

TrainSet(::DataSetConfig{>:NoTrainSet}) = nothing
TrainSet(data::DataSetConfig{>:HasTrainSet}) = throw(MethodError(TrainSet, data))
DevSet(::DataSetConfig{>:NoDevSet}) = nothing
DevSet(data::DataSetConfig{>:HasDevSet}) = throw(MethodError(DevSet, data))
TestSet(::DataSetConfig{>:NoTestSet}) = nothing
TestSet(data::DataSetConfig{>:HasTestSet}) = throw(MethodError(TestSet, data))

DataSet(::typeof(TrainSet), data::DataSetConfig{>:HasTrainSet}; kws...) = TrainSet(data; kws...)
DataSet(::typeof(DevSet), data::DataSetConfig{>:HasDevSet}; kws...) = DevSet(data; kws...)
DataSet(::typeof(TestSet), data::DataSetConfig{>:HasTestSet}; kws...) = TestSet(data; kws...)

abstract type DataSetType{T} end

abstract type IndexCapability end
struct Indexable <: IndexCapability end
struct NotIndexable <: IndexCapability end

abstract type ReIterateCapability end
struct ReIterable <: ReIterateCapability end
struct NotReIterable <: ReIterateCapability end

abstract type SampleType{T} end

abstract type TextCapability end
struct HasText <: TextCapability end
struct NoText <: TextCapability end

abstract type GraphCapability end
struct HasGraph <: GraphCapability end
struct NoGraph <: GraphCapability end
