module TextGraphBART

import Transformers
using Transformers.Layers
using Transformers.TextEncoders

using NeuralAttentionlib
using NeuralAttentionlib.Masks
using NeuralAttentionlib.Matmul

using Flux
using CUDA
using TextEncodeBase

# dataset interface
include("dataset.jl")
include("process.jl")
# datasets
include("eventnarrative.jl")
include("webnlg2020.jl")
include("traindata.jl")

# include("deppar.jl")
include("model.jl")
include("config.jl")
include("load.jl")
include("inference.jl")

# optimiser
include("grad.jl")

# training loop
include("loss.jl")
include("train.jl")

end # module TextGraphBART
