using Transformers.HuggingFace

HuggingFace.@defaultdef :textgraphbart struct TextGraphBartConfigDefault
    vocab_size::Int = 32100
    num_special_tokens::Int = 20
    max_identifier::Int = 2048
    num_attention_heads::Int = 16
    num_cross_attention_heads::Int = 16
    d_head::Int = 32
    d_cross_head::Int = 32
    d_ffn::Int = 2048
    d_model::Int = 512
    encoder_layers::Int = 6
    decoder_layers::Int = 6
    use_bias::Bool = true
    proj_head_bias::Bool = true
    act::String = "gelu"
    proj_head_act::String = "gelu"
    attention_dropout::Float64 = 0.1
    dropout::Float64 = 0.1
    init_std::Float32 = 1
    layer_norm_eps::Float64 = 1e-7
    pre_norm::Bool = true
    share_weight::Bool = false
    num_shared::Int = 6
    t5_emb_init::Bool = false
    is_encoder_decoder::Bool = true
    tie_word_embeddings::Bool = true
end

const TextGraphBartConfig = HuggingFace.HGFConfig{:textgraphbart}

TextGraphBartConfig() = TextGraphBartConfig((;), nothing)
