# RDNAS: Robust Dual-Branch Neural Architecture Search

This is the code implementation for the paper "RDNAS: Robust Dual-Branch Neural Architecture Search". 

## Requirements

- Python 3.9.21
- torch 2.4.1 + cu121
- torchvision 0.19.1 + cu121
- torchattacks 3.5.1

## Run



- Run `adv_eval_cifar/adv_test_cifar10.py` to perform adversarial evaluation of the searched architecture on CIFAR-10.
- Run `adv_eval_cifar/adv_test_cifar100.py` to perform adversarial evaluation of the searched architecture on CIFAR-100.
- Run `adv_train_cifar/cifar10_adv_train.py` to adversarially train the searched architecture on CIFAR-10.
- Run `adv_train_cifar/cifar100_adv_train.py` to adversarially train the searched architecture on CIFAR-100.
- Run `adv_train_TinyImagenet/tiny_imagenet_train.py` to adversarially train the searched architecture on Tiny-ImageNet-200.
- Run `train_search/train_search.py` to launch the NAS search process



## References
- [DARTS](https://github.com/quark0/darts)
- [AdvRush](https://github.com/nutellamok/advrush/tree/main)
- [torchattacks](https://github.com/Harry24k/adversarial-attacks-pytorch)
- [Fast Adversarial Training](https://github.com/ByungKwanLee/Super-Fast-Adversarial-Training)
